/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.client.editor;

import java.util.List;
import org.drools.workbench.screens.enums.client.editor.EnumParser;
import org.drools.workbench.screens.enums.client.editor.EnumRow;
import org.junit.Assert;
import org.junit.Test;

public class EnumParserTests {
    @Test
    public void testParsing1() {
        String content = "'Fact.field' : ['a', 'b']";
        List enums = EnumParser.parseEnums((String)"'Fact.field' : ['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((long)1L, (long)enums.size());
        Assert.assertEquals((Object)"Fact", (Object)((EnumRow)enums.get(0)).getFactName());
        Assert.assertEquals((Object)"field", (Object)((EnumRow)enums.get(0)).getFieldName());
        Assert.assertEquals((Object)"['a', 'b']", (Object)((EnumRow)enums.get(0)).getContext());
    }

    @Test
    public void testParsing2() {
        String content = "Fact.field' : ['a', 'b']";
        List enums = EnumParser.parseEnums((String)"Fact.field' : ['a', 'b']");
        Assert.assertTrue((boolean)enums.isEmpty());
    }

    @Test
    public void testParsing3() {
        String content = "'Fact.field : ['a', 'b']";
        List enums = EnumParser.parseEnums((String)"'Fact.field : ['a', 'b']");
        Assert.assertTrue((boolean)enums.isEmpty());
    }

    @Test
    public void testParsing4() {
        String content = "'Fact.field':['a', 'b']";
        List enums = EnumParser.parseEnums((String)"'Fact.field':['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((long)1L, (long)enums.size());
        Assert.assertEquals((Object)"Fact", (Object)((EnumRow)enums.get(0)).getFactName());
        Assert.assertEquals((Object)"field", (Object)((EnumRow)enums.get(0)).getFieldName());
        Assert.assertEquals((Object)"['a', 'b']", (Object)((EnumRow)enums.get(0)).getContext());
    }

    @Test
    public void testParsing5() {
        String content = "'Fact.field': ['a', 'b']";
        List enums = EnumParser.parseEnums((String)"'Fact.field': ['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((long)1L, (long)enums.size());
        Assert.assertEquals((Object)"Fact", (Object)((EnumRow)enums.get(0)).getFactName());
        Assert.assertEquals((Object)"field", (Object)((EnumRow)enums.get(0)).getFieldName());
        Assert.assertEquals((Object)"['a', 'b']", (Object)((EnumRow)enums.get(0)).getContext());
    }

    @Test
    public void testParsing6() {
        String content = "'Fact.field' :['a', 'b']";
        List enums = EnumParser.parseEnums((String)"'Fact.field' :['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((long)1L, (long)enums.size());
        Assert.assertEquals((Object)"Fact", (Object)((EnumRow)enums.get(0)).getFactName());
        Assert.assertEquals((Object)"field", (Object)((EnumRow)enums.get(0)).getFieldName());
        Assert.assertEquals((Object)"['a', 'b']", (Object)((EnumRow)enums.get(0)).getContext());
    }

    @Test
    public void testMissingFact1() {
        String content = "field' : ['a', 'b']";
        List enums = EnumParser.parseEnums((String)"field' : ['a', 'b']");
        Assert.assertTrue((boolean)enums.isEmpty());
    }

    @Test
    public void testMissingFact2() {
        String content = ".field' : ['a', 'b']";
        List enums = EnumParser.parseEnums((String)".field' : ['a', 'b']");
        Assert.assertTrue((boolean)enums.isEmpty());
    }

    @Test
    public void testMissingField1() {
        String content = "Fact' : ['a', 'b']";
        List enums = EnumParser.parseEnums((String)"Fact' : ['a', 'b']");
        Assert.assertTrue((boolean)enums.isEmpty());
    }

    @Test
    public void testMissingField2() {
        String content = "Fact.' : ['a', 'b']";
        List enums = EnumParser.parseEnums((String)"Fact.' : ['a', 'b']");
        Assert.assertTrue((boolean)enums.isEmpty());
    }

    @Test
    public void testMissingContext() {
        String content = "Fact.field' :";
        List enums = EnumParser.parseEnums((String)"Fact.field' :");
        Assert.assertTrue((boolean)enums.isEmpty());
    }

    @Test
    public void testComments() {
        String content = "'Fact.field' : ['a', 'b']\n\n#A comment\n//Another comment\n";
        List enums = EnumParser.parseEnums((String)"'Fact.field' : ['a', 'b']\n\n#A comment\n//Another comment\n");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((long)1L, (long)enums.size());
        Assert.assertEquals((Object)"Fact", (Object)((EnumRow)enums.get(0)).getFactName());
        Assert.assertEquals((Object)"field", (Object)((EnumRow)enums.get(0)).getFieldName());
        Assert.assertEquals((Object)"['a', 'b']", (Object)((EnumRow)enums.get(0)).getContext());
    }
}

