/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.client.editor;

import com.github.gwtbootstrap.client.ui.ButtonCell;
import com.github.gwtbootstrap.client.ui.CellTable;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import javax.annotation.PostConstruct;
import org.drools.workbench.screens.enums.client.editor.EnumEditorView;
import org.drools.workbench.screens.enums.client.editor.EnumParser;
import org.drools.workbench.screens.enums.client.editor.EnumRow;
import org.drools.workbench.screens.enums.client.resources.i18n.EnumEditorConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditorViewImpl;

public class EnumEditorViewImpl
extends KieEditorViewImpl
implements EnumEditorView {
    private final ListDataProvider<EnumRow> dataProvider = new ListDataProvider();

    @PostConstruct
    public void init() {
        CellTable cellTable = new CellTable(Integer.MAX_VALUE);
        cellTable.setStriped(true);
        cellTable.setCondensed(true);
        cellTable.setBordered(true);
        cellTable.setEmptyTableWidget((Widget)new Label(EnumEditorConstants.INSTANCE.noEnumsDefined()));
        cellTable.setWidth("100%");
        VerticalPanel panel = new VerticalPanel();
        panel.setWidth("100%");
        Column<EnumRow, String> factNameColumn = new Column<EnumRow, String>((Cell)new EditTextCell()){

            public String getValue(EnumRow enumRow) {
                return enumRow.getFactName();
            }
        };
        Column<EnumRow, String> fieldNameColumn = new Column<EnumRow, String>((Cell)new EditTextCell()){

            public String getValue(EnumRow enumRow) {
                return enumRow.getFieldName();
            }
        };
        Column<EnumRow, String> contextColumn = new Column<EnumRow, String>((Cell)new EditTextCell()){

            public String getValue(EnumRow enumRow) {
                return enumRow.getContext();
            }
        };
        ButtonCell deleteEnumButton = new ButtonCell(ButtonSize.SMALL);
        deleteEnumButton.setType(ButtonType.DANGER);
        deleteEnumButton.setIcon(IconType.MINUS_SIGN);
        Column<EnumRow, String> deleteEnumColumn = new Column<EnumRow, String>((Cell)deleteEnumButton){

            public String getValue(EnumRow global) {
                return EnumEditorConstants.INSTANCE.remove();
            }
        };
        deleteEnumColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow object, String value) {
                EnumEditorViewImpl.this.dataProvider.getList().remove(index);
            }
        });
        factNameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow object, String value) {
                object.setFactName(value);
            }
        });
        fieldNameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow object, String value) {
                object.setFieldName(value);
            }
        });
        contextColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow object, String value) {
                object.setContext(value);
            }
        });
        cellTable.addColumn((Column)factNameColumn, EnumEditorConstants.INSTANCE.FactColumnHeader());
        cellTable.addColumn((Column)fieldNameColumn, EnumEditorConstants.INSTANCE.FieldColumnHeader());
        cellTable.addColumn((Column)contextColumn, EnumEditorConstants.INSTANCE.ContextColumnHeader());
        cellTable.addColumn((Column)deleteEnumColumn);
        this.dataProvider.addDataDisplay((HasData)cellTable);
        Button addButton = new Button(EnumEditorConstants.INSTANCE.AddEnum(), new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                EnumRow enumRow = new EnumRow();
                EnumEditorViewImpl.this.dataProvider.getList().add(enumRow);
            }
        });
        panel.add((Widget)addButton);
        panel.add((Widget)cellTable);
        this.initWidget((Widget)panel);
    }

    @Override
    public void setContent(String content) {
        this.dataProvider.setList(EnumParser.parseEnums(content));
    }

    @Override
    public String getContent() {
        if (this.dataProvider.getList().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (EnumRow enumRow : this.dataProvider.getList()) {
            if (!enumRow.isValid()) continue;
            sb.append(enumRow.toString()).append("\n");
        }
        return sb.toString();
    }
}

