/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.enums.client.editor.EnumEditorView;
import org.drools.workbench.screens.enums.client.type.EnumResourceType;
import org.drools.workbench.screens.enums.model.EnumModelContent;
import org.drools.workbench.screens.enums.service.EnumService;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="EnumEditor", supportedTypes={EnumResourceType.class})
public class EnumEditorPresenter
extends KieEditor {
    private EnumEditorView view;
    @Inject
    private Caller<EnumService> enumService;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private EnumResourceType type;

    @Inject
    public EnumEditorPresenter(EnumEditorView baseView) {
        super((KieEditorView)baseView);
        this.view = baseView;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((EnumService)this.enumService.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    private RemoteCallback<EnumModelContent> getModelSuccessCallback() {
        return new RemoteCallback<EnumModelContent>(){

            public void callback(EnumModelContent content) {
                if (EnumEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                EnumEditorPresenter.this.resetEditorPages(content.getOverview());
                EnumEditorPresenter.this.addSourcePage();
                EnumEditorPresenter.this.view.setContent(content.getModel().getDRL());
                EnumEditorPresenter.this.view.hideBusyIndicator();
                EnumEditorPresenter.this.createOriginalHash(EnumEditorPresenter.this.view.getContent());
            }
        };
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                ((EnumService)EnumEditorPresenter.this.enumService.call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

                    public void callback(List<ValidationMessage> results) {
                        if (results == null || results.isEmpty()) {
                            EnumEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                        } else {
                            ValidationPopup.showMessages(results);
                        }
                    }
                }, (ErrorCallback)new DefaultErrorCallback())).validate((Path)EnumEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)EnumEditorPresenter.this.view.getContent());
            }
        };
    }

    protected void save(String commitMessage) {
        ((EnumService)this.enumService.call(this.getSaveSuccessCallback(this.view.getContent().hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.view.getContent(), this.metadata, commitMessage);
    }

    public void onSourceTabSelected() {
        this.updateSource(this.view.getContent());
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.view.getContent());
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

