/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.client.editor;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.screens.enums.client.editor.EnumParser;
import org.drools.workbench.screens.enums.client.editor.EnumRow;
import org.junit.Assert;
import org.junit.Test;

public class EnumParserTests {
    @Test
    public void testFromStringParsing1() {
        String content = "'Fact.field' : ['a', 'b']";
        List enums = EnumParser.fromString((String)"'Fact.field' : ['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((long)1L, (long)enums.size());
        Assert.assertEquals((Object)"Fact", (Object)((EnumRow)enums.get(0)).getFactName());
        Assert.assertEquals((Object)"field", (Object)((EnumRow)enums.get(0)).getFieldName());
        Assert.assertEquals((Object)"['a', 'b']", (Object)((EnumRow)enums.get(0)).getContext());
    }

    @Test
    public void testFromStringParsing2() {
        String content = "Fact.field' : ['a', 'b']";
        List enums = EnumParser.fromString((String)"Fact.field' : ['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((Object)"Fact.field' : ['a', 'b']", (Object)((EnumRow)enums.get(0)).getRaw());
    }

    @Test
    public void testFromStringParsing3() {
        String content = "'Fact.field : ['a', 'b']";
        List enums = EnumParser.fromString((String)"'Fact.field : ['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((Object)"'Fact.field : ['a', 'b']", (Object)((EnumRow)enums.get(0)).getRaw());
    }

    @Test
    public void testFromStringParsing4() {
        String content = "'Fact.field':['a', 'b']";
        List enums = EnumParser.fromString((String)"'Fact.field':['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((long)1L, (long)enums.size());
        Assert.assertEquals((Object)"Fact", (Object)((EnumRow)enums.get(0)).getFactName());
        Assert.assertEquals((Object)"field", (Object)((EnumRow)enums.get(0)).getFieldName());
        Assert.assertEquals((Object)"['a', 'b']", (Object)((EnumRow)enums.get(0)).getContext());
    }

    @Test
    public void testFromStringParsing5() {
        String content = "'Fact.field': ['a', 'b']";
        List enums = EnumParser.fromString((String)"'Fact.field': ['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((long)1L, (long)enums.size());
        Assert.assertEquals((Object)"Fact", (Object)((EnumRow)enums.get(0)).getFactName());
        Assert.assertEquals((Object)"field", (Object)((EnumRow)enums.get(0)).getFieldName());
        Assert.assertEquals((Object)"['a', 'b']", (Object)((EnumRow)enums.get(0)).getContext());
    }

    @Test
    public void testFromStringParsing6() {
        String content = "'Fact.field' :['a', 'b']";
        List enums = EnumParser.fromString((String)"'Fact.field' :['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((long)1L, (long)enums.size());
        Assert.assertEquals((Object)"Fact", (Object)((EnumRow)enums.get(0)).getFactName());
        Assert.assertEquals((Object)"field", (Object)((EnumRow)enums.get(0)).getFieldName());
        Assert.assertEquals((Object)"['a', 'b']", (Object)((EnumRow)enums.get(0)).getContext());
    }

    @Test
    public void testFromStringMissingFact1() {
        String content = "field' : ['a', 'b']";
        List enums = EnumParser.fromString((String)"field' : ['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((Object)"field' : ['a', 'b']", (Object)((EnumRow)enums.get(0)).getRaw());
    }

    @Test
    public void testFromStringMissingFact2() {
        String content = ".field' : ['a', 'b']";
        List enums = EnumParser.fromString((String)".field' : ['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((Object)".field' : ['a', 'b']", (Object)((EnumRow)enums.get(0)).getRaw());
    }

    @Test
    public void testFromStringMissingField1() {
        String content = "Fact' : ['a', 'b']";
        List enums = EnumParser.fromString((String)"Fact' : ['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((Object)"Fact' : ['a', 'b']", (Object)((EnumRow)enums.get(0)).getRaw());
    }

    @Test
    public void testFromStringMissingField2() {
        String content = "Fact.' : ['a', 'b']";
        List enums = EnumParser.fromString((String)"Fact.' : ['a', 'b']");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((Object)"Fact.' : ['a', 'b']", (Object)((EnumRow)enums.get(0)).getRaw());
    }

    @Test
    public void testFromStringMissingContext() {
        String content = "Fact.field' :";
        List enums = EnumParser.fromString((String)"Fact.field' :");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((Object)"Fact.field' :", (Object)((EnumRow)enums.get(0)).getRaw());
    }

    @Test
    public void testFromStringInvalidSyntax() {
        String content = "This isn't even close to a correct definition";
        List enums = EnumParser.fromString((String)"This isn't even close to a correct definition");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((Object)"This isn't even close to a correct definition", (Object)((EnumRow)enums.get(0)).getRaw());
    }

    @Test
    public void testFromStringComments() {
        String content = "'Fact.field' : ['a', 'b']\n\n#A comment\n//Another comment\n";
        List enums = EnumParser.fromString((String)"'Fact.field' : ['a', 'b']\n\n#A comment\n//Another comment\n");
        Assert.assertFalse((boolean)enums.isEmpty());
        Assert.assertEquals((long)1L, (long)enums.size());
        Assert.assertEquals((Object)"Fact", (Object)((EnumRow)enums.get(0)).getFactName());
        Assert.assertEquals((Object)"field", (Object)((EnumRow)enums.get(0)).getFieldName());
        Assert.assertEquals((Object)"['a', 'b']", (Object)((EnumRow)enums.get(0)).getContext());
    }

    @Test
    public void testToString1() {
        ArrayList<EnumRow> content = new ArrayList<EnumRow>(){
            {
                this.add(new EnumRow("Fact", "field", "['a', 'b']"));
                this.add(new EnumRow("A raw value"));
            }
        };
        String enums = EnumParser.toString((List)content);
        Assert.assertEquals((Object)enums, (Object)"'Fact.field' : ['a', 'b']\nA raw value\n");
    }
}

