/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.client.editor;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.List;
import javax.annotation.PostConstruct;
import org.drools.workbench.screens.enums.client.editor.EnumEditTextCell;
import org.drools.workbench.screens.enums.client.editor.EnumEditorView;
import org.drools.workbench.screens.enums.client.editor.EnumRow;
import org.drools.workbench.screens.enums.client.resources.i18n.EnumEditorConstants;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.kie.workbench.common.widgets.metadata.client.KieEditorViewImpl;

public class EnumEditorViewImpl
extends KieEditorViewImpl
implements EnumEditorView {
    private final ListDataProvider<EnumRow> dataProvider = new ListDataProvider();

    @PostConstruct
    public void init() {
        CellTable cellTable = new CellTable(Integer.MAX_VALUE);
        cellTable.setStriped(true);
        cellTable.setCondensed(true);
        cellTable.setBordered(true);
        cellTable.setEmptyTableWidget((Widget)new Label(EnumEditorConstants.INSTANCE.noEnumsDefined()));
        cellTable.setWidth("100%");
        VerticalPanel panel = new VerticalPanel();
        panel.setWidth("100%");
        Column<EnumRow, String> factNameColumn = new Column<EnumRow, String>((Cell)new EnumEditTextCell()){

            public String getValue(EnumRow enumRow) {
                if (enumRow.isValid()) {
                    return enumRow.getFactName();
                }
                return enumRow.getRaw();
            }
        };
        Column<EnumRow, String> fieldNameColumn = new Column<EnumRow, String>((Cell)new EnumEditTextCell()){

            public String getValue(EnumRow enumRow) {
                if (enumRow.isValid()) {
                    return enumRow.getFieldName();
                }
                return "";
            }
        };
        Column<EnumRow, String> contextColumn = new Column<EnumRow, String>((Cell)new EnumEditTextCell()){

            public String getValue(EnumRow enumRow) {
                if (enumRow.isValid()) {
                    return enumRow.getContext();
                }
                return "";
            }
        };
        ButtonCell deleteEnumButton = new ButtonCell(IconType.MINUS, ButtonType.DANGER, ButtonSize.SMALL);
        Column<EnumRow, String> deleteEnumColumn = new Column<EnumRow, String>((Cell)deleteEnumButton){

            public String getValue(EnumRow global) {
                return EnumEditorConstants.INSTANCE.remove();
            }
        };
        factNameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow enumRow, String value) {
                enumRow.setFactName(value);
            }
        });
        fieldNameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow enumRow, String value) {
                enumRow.setFieldName(value);
            }
        });
        contextColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow enumRow, String value) {
                enumRow.setContext(value);
            }
        });
        deleteEnumColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<EnumRow, String>(){

            public void update(int index, EnumRow enumRow, String value) {
                EnumEditorViewImpl.this.dataProvider.getList().remove(index);
            }
        });
        cellTable.addColumn((Column)factNameColumn, EnumEditorConstants.INSTANCE.FactColumnHeader());
        cellTable.addColumn((Column)fieldNameColumn, EnumEditorConstants.INSTANCE.FieldColumnHeader());
        cellTable.addColumn((Column)contextColumn, EnumEditorConstants.INSTANCE.ContextColumnHeader());
        cellTable.addColumn((Column)deleteEnumColumn);
        cellTable.setColumnWidth((Column)deleteEnumColumn, 100.0, Style.Unit.PX);
        this.dataProvider.addDataDisplay((HasData)cellTable);
        Button addButton = new Button(EnumEditorConstants.INSTANCE.AddEnum(), new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                EnumRow enumRow = new EnumRow();
                EnumEditorViewImpl.this.dataProvider.getList().add(enumRow);
            }
        });
        panel.add((Widget)addButton);
        panel.add((Widget)cellTable);
        this.initWidget((Widget)panel);
    }

    @Override
    public void setContent(List<EnumRow> content) {
        this.dataProvider.setList(content);
    }

    @Override
    public List<EnumRow> getContent() {
        return this.dataProvider.getList();
    }
}

