/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import org.drools.workbench.screens.enums.client.editor.EnumEditorPresenter;
import org.drools.workbench.screens.enums.client.editor.EnumEditorView;
import org.drools.workbench.screens.enums.client.editor.EnumRow;
import org.drools.workbench.screens.enums.client.type.EnumResourceType;
import org.drools.workbench.screens.enums.model.EnumModel;
import org.drools.workbench.screens.enums.model.EnumModelContent;
import org.drools.workbench.screens.enums.service.EnumService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.source.ViewDRLSourceWidget;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class EnumEditorPresenterTests {
    @Mock
    private EnumEditorView view;
    @Mock
    private KieEditorWrapperView mockKieView;
    @Mock
    private OverviewWidgetPresenter mockOverviewWidget;
    @Mock
    private VersionRecordManager mockVersionRecordManager;
    @Mock
    private FileMenuBuilder mockFileMenuBuilder;
    @Mock
    private DefaultFileNameValidator mockFileNameValidator;
    @Mock
    private EnumService enumService;
    private Caller<EnumService> enumServiceCaller;
    @Mock
    private ObservablePath path;
    @Mock
    private PlaceRequest place;
    @Mock
    private Overview overview;
    @Mock
    private ValidationPopup validationPopup;
    @GwtMock
    private ViewDRLSourceWidget sourceWidget;
    @Captor
    private ArgumentCaptor<List<EnumRow>> enumsArgumentCaptor;
    @Captor
    private ArgumentCaptor<String> enumStringArgumentCaptor;
    private Event<NotificationEvent> mockNotification = new EventSourceMock<NotificationEvent>(){

        public void fire(NotificationEvent event) {
        }
    };
    private EnumResourceType type;
    private EnumEditorPresenter presenter;
    private EnumModelContent content;
    private EnumModel model;

    @Before
    public void setup() {
        this.type = (EnumResourceType)GWT.create(EnumResourceType.class);
        Mockito.when((Object)this.mockFileMenuBuilder.addSave((MenuItem)Mockito.any(MenuItem.class))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockFileMenuBuilder.addCopy((Path)Mockito.any(ObservablePath.class), (Validator)Mockito.eq((Object)this.mockFileNameValidator))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockFileMenuBuilder.addRename((Path)Mockito.any(ObservablePath.class), (Validator)Mockito.eq((Object)this.mockFileNameValidator))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockFileMenuBuilder.addDelete((Path)Mockito.any(ObservablePath.class))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockFileMenuBuilder.addValidate((Command)Mockito.any(Command.class))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockFileMenuBuilder.addNewTopLevelMenu((MenuItem)Mockito.any(MenuItem.class))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockVersionRecordManager.getCurrentPath()).thenReturn((Object)this.path);
        Mockito.when((Object)this.mockVersionRecordManager.getPathToLatest()).thenReturn((Object)this.path);
        this.model = new EnumModel("'Fact.field' : ['a', 'b']");
        this.content = new EnumModelContent(this.model, this.overview);
        Mockito.when((Object)this.enumService.loadContent((Path)this.path)).thenReturn((Object)this.content);
        Mockito.when((Object)this.view.getContent()).thenReturn((Object)new ArrayList<EnumRow>(){
            {
                this.add(new EnumRow("Fact", "field", "['a', 'b']"));
            }
        });
        this.enumServiceCaller = new CallerMock((Object)this.enumService);
        this.presenter = new EnumEditorPresenter(this.view, this.enumServiceCaller, this.type, this.validationPopup){
            {
                this.kieView = EnumEditorPresenterTests.this.mockKieView;
                this.overviewWidget = EnumEditorPresenterTests.this.mockOverviewWidget;
                this.menuBuilder = EnumEditorPresenterTests.this.mockFileMenuBuilder;
                this.fileNameValidator = EnumEditorPresenterTests.this.mockFileNameValidator;
                this.versionRecordManager = EnumEditorPresenterTests.this.mockVersionRecordManager;
                this.notification = EnumEditorPresenterTests.this.mockNotification;
            }
        };
    }

    @Test
    public void testOnStartup() {
        this.presenter.onStartup(this.path, this.place);
        ((EnumService)Mockito.verify((Object)this.enumService, (VerificationMode)Mockito.times((int)1))).loadContent((Path)this.path);
        ((EnumEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContent((List)this.enumsArgumentCaptor.capture());
        ((EnumEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        List enums = (List)this.enumsArgumentCaptor.getValue();
        Assert.assertNotNull((Object)enums);
        Assert.assertEquals((long)1L, (long)enums.size());
        EnumRow enumRow = (EnumRow)enums.get(0);
        Assert.assertNotNull((Object)enumRow);
        Assert.assertEquals((Object)"Fact", (Object)enumRow.getFactName());
        Assert.assertEquals((Object)"field", (Object)enumRow.getFieldName());
        Assert.assertEquals((Object)"['a', 'b']", (Object)enumRow.getContext());
    }

    @Test
    public void testOnSave() {
        this.presenter.onStartup(this.path, this.place);
        this.presenter.save("message");
        ((EnumEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getContent();
        ((EnumService)Mockito.verify((Object)this.enumService, (VerificationMode)Mockito.times((int)1))).save((Path)Mockito.eq((Object)this.path), this.enumStringArgumentCaptor.capture(), (Metadata)Mockito.any(Metadata.class), (String)Mockito.eq((Object)"message"));
        String enumString = (String)this.enumStringArgumentCaptor.getValue();
        Assert.assertNotNull((Object)enumString);
        Assert.assertEquals((Object)enumString, (Object)"'Fact.field' : ['a', 'b']\n");
    }

    @Test
    public void testOnSourceTabSelected() {
        this.presenter.onStartup(this.path, this.place);
        this.presenter.onSourceTabSelected();
        ((EnumEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getContent();
    }
}

