/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.enums.client.editor.EnumEditorView;
import org.drools.workbench.screens.enums.client.editor.EnumParser;
import org.drools.workbench.screens.enums.client.editor.EnumRow;
import org.drools.workbench.screens.enums.client.type.EnumResourceType;
import org.drools.workbench.screens.enums.model.EnumModelContent;
import org.drools.workbench.screens.enums.service.EnumService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.callbacks.CommandErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="EnumEditor", supportedTypes={EnumResourceType.class})
public class EnumEditorPresenter
extends KieEditor<String> {
    private EnumEditorView view;
    private Caller<EnumService> enumService;
    private EnumResourceType type;
    private ValidationPopup validationPopup;

    public EnumEditorPresenter() {
    }

    @Inject
    public EnumEditorPresenter(EnumEditorView baseView, Caller<EnumService> enumService, EnumResourceType type, ValidationPopup validationPopup) {
        super((KieEditorView)baseView);
        this.view = baseView;
        this.enumService = enumService;
        this.type = type;
        this.validationPopup = validationPopup;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((EnumService)this.enumService.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    protected Supplier<String> getContentSupplier() {
        return () -> EnumParser.toString(this.view.getContent());
    }

    protected Caller<? extends SupportsSaveAndRename<String, Metadata>> getSaveAndRenameServiceCaller() {
        return this.enumService;
    }

    private RemoteCallback<EnumModelContent> getModelSuccessCallback() {
        return new RemoteCallback<EnumModelContent>(){

            public void callback(EnumModelContent content) {
                if (EnumEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                EnumEditorPresenter.this.resetEditorPages(content.getOverview());
                EnumEditorPresenter.this.addSourcePage();
                List<EnumRow> enumDefinitions = EnumParser.fromString(content.getModel().getEnumDefinitions());
                EnumEditorPresenter.this.view.setContent(enumDefinitions);
                EnumEditorPresenter.this.view.hideBusyIndicator();
                EnumEditorPresenter.this.createOriginalHash(EnumParser.toString(enumDefinitions));
            }
        };
    }

    protected void onValidate(Command finished) {
        ((EnumService)this.enumService.call((RemoteCallback)this.validationPopup.getValidationCallback(finished), (ErrorCallback)new CommandErrorCallback(finished))).validate((Path)this.versionRecordManager.getCurrentPath(), (Object)EnumParser.toString(this.view.getContent()));
    }

    protected void save(String commitMessage) {
        List<EnumRow> content = this.view.getContent();
        ((EnumService)this.enumService.call(this.getSaveSuccessCallback(content.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)EnumParser.toString(content), (Object)this.metadata, commitMessage);
    }

    public void onSourceTabSelected() {
        this.updateSource(EnumParser.toString(this.view.getContent()));
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose(this.view.getContent());
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

