/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.client.editor;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.enums.client.editor.EnumEditTextCell;
import org.drools.workbench.screens.enums.client.editor.EnumRow;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class EnumEditorTextCellTest {
    private Cell.Context context;
    @Mock
    private Element parent;
    @Mock
    private NativeEvent event;
    @Mock
    private ValueUpdater<String> valueUpdater;
    @Captor
    private ArgumentCaptor<SafeHtml> safeHtmlArgumentCaptor;
    @Spy
    private EnumEditTextCell cell;

    @Test
    public void testOnBrowserEventEnabled() {
        this.context = new Cell.Context(0, 0, (Object)new EnumRow("Fact", "field", "['a', 'b']"));
        this.cell.onBrowserEvent(this.context, this.parent, "Fact", this.event, this.valueUpdater);
        ((EnumEditTextCell)Mockito.verify((Object)this.cell, (VerificationMode)Mockito.times((int)1))).doOnBrowserEvent((Cell.Context)Mockito.eq((Object)this.context), (Element)Mockito.eq((Object)this.parent), (String)Mockito.eq((Object)"Fact"), (NativeEvent)Mockito.eq((Object)this.event), (ValueUpdater)Mockito.eq(this.valueUpdater));
    }

    @Test
    public void testOnBrowserEventDisabled() {
        this.context = new Cell.Context(0, 0, (Object)new EnumRow("A raw value"));
        this.cell.onBrowserEvent(this.context, this.parent, "Fact", this.event, this.valueUpdater);
        ((EnumEditTextCell)Mockito.verify((Object)this.cell, (VerificationMode)Mockito.never())).doOnBrowserEvent((Cell.Context)Mockito.eq((Object)this.context), (Element)Mockito.eq((Object)this.parent), (String)Mockito.eq((Object)"Fact"), (NativeEvent)Mockito.eq((Object)this.event), (ValueUpdater)Mockito.eq(this.valueUpdater));
    }

    @Test
    public void testRenderEnabled() {
        this.context = new Cell.Context(0, 0, (Object)new EnumRow("Fact", "field", "['a', 'b']"));
        SafeHtmlBuilder sb = (SafeHtmlBuilder)Mockito.mock(SafeHtmlBuilder.class);
        this.cell.render(this.context, "Fact", sb);
        ((EnumEditTextCell)Mockito.verify((Object)this.cell, (VerificationMode)Mockito.times((int)1))).doRender((Cell.Context)Mockito.eq((Object)this.context), (String)Mockito.eq((Object)"Fact"), (SafeHtmlBuilder)Mockito.eq((Object)sb));
    }

    @Test
    public void testRenderDisabled() {
        this.context = new Cell.Context(0, 0, (Object)new EnumRow("A raw value"));
        SafeHtmlBuilder safeHtmlBuilder = (SafeHtmlBuilder)Mockito.mock(SafeHtmlBuilder.class);
        this.cell.render(this.context, "Fact", safeHtmlBuilder);
        ((EnumEditTextCell)Mockito.verify((Object)this.cell, (VerificationMode)Mockito.never())).doRender((Cell.Context)Mockito.eq((Object)this.context), (String)Mockito.eq((Object)"Fact"), (SafeHtmlBuilder)Mockito.eq((Object)safeHtmlBuilder));
        ((SafeHtmlBuilder)Mockito.verify((Object)safeHtmlBuilder, (VerificationMode)Mockito.times((int)1))).append((SafeHtml)this.safeHtmlArgumentCaptor.capture());
        SafeHtml safeHtml = (SafeHtml)this.safeHtmlArgumentCaptor.getValue();
        Assert.assertEquals((Object)"cellContent(disabled, invalidDefinitionDisabled, Fact)", (Object)safeHtml.asString());
    }
}

