/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.client.editor;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.screens.enums.client.editor.EnumRow;

public class EnumParser {
    private EnumParser() {
    }

    public static List<EnumRow> fromString(String content) {
        ArrayList<EnumRow> enums = new ArrayList<EnumRow>();
        if (content == null || content.isEmpty()) {
            return enums;
        }
        String[] lines = content.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            EnumRow er = EnumParser.parseEnum(line);
            if (er == null) continue;
            enums.add(er);
        }
        return enums;
    }

    private static EnumRow parseEnum(String line) {
        String context;
        if (line.equals("") || line.startsWith("#") || line.startsWith("//")) {
            return null;
        }
        int colonIndex = line.indexOf(":");
        if (colonIndex < 0) {
            return new EnumRow(line);
        }
        String factField = line.substring(0, colonIndex);
        int dotIndex = (factField = factField.trim()).indexOf(".");
        if (dotIndex < 0) {
            return new EnumRow(line);
        }
        String factName = factField.substring(0, dotIndex);
        factName = factName.trim();
        String fieldName = factField.substring(dotIndex + 1, factField.length());
        fieldName = fieldName.trim();
        if (!factName.startsWith("'")) {
            return new EnumRow(line);
        }
        if (!fieldName.endsWith("'")) {
            return new EnumRow(line);
        }
        EnumRow er = new EnumRow(factName = factName.substring(1).trim(), fieldName = fieldName.substring(0, fieldName.length() - 1).trim(), context = line.substring(colonIndex + 1).trim());
        if (!er.isValid()) {
            return new EnumRow(line);
        }
        return er;
    }

    public static String toString(List<EnumRow> content) {
        if (content == null || content.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (EnumRow enumRow : content) {
            sb.append(enumRow.toString()).append("\n");
        }
        return sb.toString();
    }
}

