/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.client.editor;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.enums.client.editor.EnumEditorViewImpl;
import org.drools.workbench.screens.enums.client.editor.EnumRow;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;

@RunWith(value=GwtMockitoTestRunner.class)
public class EnumEditorViewImplTest {
    @Mock
    private Button addButton;
    @Spy
    private ListDataProvider<EnumRow> dataProvider;
    @Captor
    private ArgumentCaptor<ClickHandler> clickHandlerCaptor;
    private EnumEditorViewImpl view;

    @Before
    public void setUp() throws Exception {
        this.view = new EnumEditorViewImpl(this.dataProvider, this.addButton);
    }

    @Test
    public void testClickCauseAdditionOfRow() throws Exception {
        this.view.init();
        Assertions.assertThat((List)this.dataProvider.getList()).hasSize(0);
        ((ListDataProvider)Mockito.verify(this.dataProvider)).addDataDisplay((HasData)Matchers.any(CellTable.class));
        ((Button)Mockito.verify((Object)this.addButton)).addClickHandler((ClickHandler)this.clickHandlerCaptor.capture());
        ((ClickHandler)this.clickHandlerCaptor.getValue()).onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        Assertions.assertThat((List)this.dataProvider.getList()).hasSize(1);
        EnumRow newRow = (EnumRow)this.dataProvider.getList().get(0);
        Assertions.assertThat((String)newRow.getContext()).isEmpty();
        Assertions.assertThat((String)newRow.getFactName()).isEmpty();
        Assertions.assertThat((String)newRow.getFieldName()).isEmpty();
        Assertions.assertThat((String)newRow.getRaw()).isEmpty();
    }

    @Test
    public void testSetAndGetContent() throws Exception {
        List<EnumRow> testedRows = Collections.singletonList(new EnumRow());
        this.view.setContent(testedRows);
        Assertions.assertThat((List)this.dataProvider.getList()).hasSize(1);
        Assertions.assertThat((List)this.dataProvider.getList()).containsExactly((Object[])new EnumRow[]{testedRows.get(0)});
        Assertions.assertThat((List)this.view.getContent()).hasSize(1);
        Assertions.assertThat((List)this.view.getContent()).containsExactly((Object[])new EnumRow[]{testedRows.get(0)});
    }
}

