/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.factmodel.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.factmodel.backend.server.util.FactModelPersistence;
import org.drools.workbench.screens.factmodel.model.FactMetaModel;
import org.drools.workbench.screens.factmodel.model.FactModelContent;
import org.drools.workbench.screens.factmodel.model.FactModels;
import org.drools.workbench.screens.factmodel.service.FactModelService;
import org.drools.workbench.screens.factmodel.type.FactModelResourceTypeDefinition;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.guvnor.common.services.backend.file.FileExtensionFilter;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.file.CopyService;
import org.guvnor.common.services.shared.file.DeleteService;
import org.guvnor.common.services.shared.file.RenameService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.BuilderResult;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.workbench.common.services.backend.source.SourceServices;
import org.kie.workbench.common.services.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.service.DataModelService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceOpenedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Service
@ApplicationScoped
public class FactModelServiceImpl
implements FactModelService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCache;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private Event<ResourceAddedEvent> resourceAddedEvent;
    @Inject
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Inject
    private Paths paths;
    @Inject
    private Identity identity;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private SourceServices sourceServices;
    @Inject
    private ProjectService projectService;
    @Inject
    private FactModelResourceTypeDefinition typeDefinition;
    @Inject
    private FileDiscoveryService fileDiscoveryService;

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, FactModels content, String comment) {
        try {
            Package pkg = this.projectService.resolvePackage(context);
            String packageName = pkg == null ? null : pkg.getPackageName();
            content.setPackageName(packageName);
            Path nioPath = this.paths.convert(context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = this.paths.convert(nioPath, false);
            this.ioService.createFile(nioPath, new FileAttribute[0]);
            this.ioService.write(nioPath, FactModelPersistence.marshal(content), new OpenOption[]{this.makeCommentedOption(comment)});
            this.resourceAddedEvent.fire((Object)new ResourceAddedEvent(newPath));
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public FactModels load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(this.paths.convert(path));
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path));
            return FactModelPersistence.unmarshal(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public FactModelContent loadContent(org.uberfire.backend.vfs.Path path) {
        try {
            FactModels factModels = this.load(path);
            List<FactMetaModel> allAvailableTypes = this.loadAllAvailableTypes(path);
            allAvailableTypes.addAll(factModels.getModels());
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            return new FactModelContent(factModels, allAvailableTypes, oracle);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private List<FactMetaModel> loadAllAvailableTypes(org.uberfire.backend.vfs.Path path) {
        ArrayList<FactMetaModel> allAvailableTypes = new ArrayList<FactMetaModel>();
        org.uberfire.backend.vfs.Path projectRoot = this.projectService.resolveProject(path).getRootPath();
        if (projectRoot == null) {
            return allAvailableTypes;
        }
        Path nioProjectRoot = this.paths.convert(projectRoot);
        Path nioSrcRoot = nioProjectRoot.resolve("src/main/resources");
        Collection modelNioPaths = this.fileDiscoveryService.discoverFiles(nioSrcRoot, (DirectoryStream.Filter)new FileExtensionFilter(this.typeDefinition.getSuffix()), true);
        for (Path modelNioPath : modelNioPaths) {
            org.uberfire.backend.vfs.Path modelPath = this.paths.convert(modelNioPath);
            if (modelPath.equals(path)) continue;
            List model = this.load(modelPath).getModels();
            allAvailableTypes.addAll(model);
        }
        return allAvailableTypes;
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, FactModels content, Metadata metadata, String comment) {
        try {
            Package pkg = this.projectService.resolvePackage(resource);
            String packageName = pkg == null ? null : pkg.getPackageName();
            content.setPackageName(packageName);
            this.ioService.write(this.paths.convert(resource), FactModelPersistence.marshal(content), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(resource));
            this.resourceUpdatedEvent.fire((Object)new ResourceUpdatedEvent(resource));
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String toSource(org.uberfire.backend.vfs.Path path, FactModels model) {
        try {
            return this.sourceServices.getServiceFor(this.paths.convert(path)).getSource(this.paths.convert(path), (Object)FactModelPersistence.marshal(model));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public BuilderResult validate(org.uberfire.backend.vfs.Path path, FactModels content) {
        return new BuilderResult();
    }

    public boolean isValid(org.uberfire.backend.vfs.Path path, FactModels content) {
        return !this.validate(path, content).hasLines();
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(name, null, commitMessage, when);
        return co;
    }
}

