/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.factmodel.backend.server.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.workbench.models.commons.backend.imports.ImportsParser;
import org.drools.workbench.models.commons.backend.imports.ImportsWriter;
import org.drools.workbench.models.commons.backend.packages.PackageNameParser;
import org.drools.workbench.models.commons.backend.packages.PackageNameWriter;
import org.drools.workbench.models.datamodel.imports.HasImports;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.packages.HasPackageName;
import org.drools.workbench.screens.factmodel.model.AnnotationMetaModel;
import org.drools.workbench.screens.factmodel.model.FactMetaModel;
import org.drools.workbench.screens.factmodel.model.FactModels;
import org.drools.workbench.screens.factmodel.model.FieldMetaModel;
import org.uberfire.commons.validation.Preconditions;

public class FactModelPersistence {
    public static String marshal(FactModels content) {
        StringBuilder sb = new StringBuilder();
        PackageNameWriter.write((StringBuilder)sb, (HasPackageName)content);
        ImportsWriter.write((StringBuilder)sb, (HasImports)content);
        for (FactMetaModel factMetaModel : content.getModels()) {
            sb.append(FactModelPersistence.toDRL(factMetaModel)).append("\n\n");
        }
        return sb.toString().trim();
    }

    private static String toDRL(FactMetaModel mm) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("declare ").append(mm.getName());
        if (mm.hasSuperType()) {
            sb.append(" extends ");
            sb.append(mm.getSuperType());
        }
        for (i = 0; i < mm.getAnnotations().size(); ++i) {
            AnnotationMetaModel a = (AnnotationMetaModel)mm.getAnnotations().get(i);
            sb.append("\n\t");
            sb.append((CharSequence)FactModelPersistence.buildAnnotationDRL(a));
        }
        for (i = 0; i < mm.getFields().size(); ++i) {
            FieldMetaModel f = (FieldMetaModel)mm.getFields().get(i);
            sb.append("\n\t");
            sb.append(f.name).append(": ").append(f.type);
        }
        sb.append("\nend");
        return sb.toString();
    }

    private static StringBuilder buildAnnotationDRL(AnnotationMetaModel a) {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(a.name);
        sb.append("(");
        for (Map.Entry e : a.getValues().entrySet()) {
            if (e.getKey() != null && ((String)e.getKey()).length() > 0) {
                sb.append((String)e.getKey());
                sb.append(" = ");
            }
            if (e.getValue() != null && ((String)e.getValue()).length() > 0) {
                sb.append((String)e.getValue());
            }
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(")");
        return sb;
    }

    public static FactModels unmarshal(String content) {
        try {
            List<FactMetaModel> models = FactModelPersistence.toModel(content);
            FactModels factModels = new FactModels();
            factModels.getModels().addAll(models);
            String packageName = PackageNameParser.parsePackageName((String)content);
            factModels.setPackageName(packageName);
            Imports imports = ImportsParser.parseImports((String)content);
            factModels.setImports(imports);
            return factModels;
        }
        catch (DroolsParserException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<FactMetaModel> toModel(String drl) throws DroolsParserException {
        Preconditions.checkNotNull((String)drl, (Object)"The string representing DRL can't be null!");
        if (drl.startsWith("#advanced") || drl.startsWith("//advanced")) {
            throw new DroolsParserException("Using advanced editor");
        }
        DrlParser parser = new DrlParser();
        StringReader reader = new StringReader(drl);
        PackageDescr pkg = parser.parse((Reader)reader);
        if (parser.hasErrors()) {
            throw new DroolsParserException("The model drl " + drl + " is not valid");
        }
        if (pkg == null) {
            return Collections.emptyList();
        }
        List types = pkg.getTypeDeclarations();
        ArrayList<FactMetaModel> list = new ArrayList<FactMetaModel>(types.size());
        for (TypeDeclarationDescr td : types) {
            FactMetaModel mm = new FactMetaModel();
            mm.setName(td.getTypeName());
            mm.setSuperType(td.getSuperTypeName());
            Map fields = td.getFields();
            for (Map.Entry en : fields.entrySet()) {
                String fieldName = (String)en.getKey();
                TypeFieldDescr descr = (TypeFieldDescr)en.getValue();
                FieldMetaModel fm = new FieldMetaModel(fieldName, descr.getPattern().getObjectType());
                mm.getFields().add(fm);
            }
            Map annotations = td.getAnnotations();
            for (Map.Entry en : annotations.entrySet()) {
                String annotationName = (String)en.getKey();
                AnnotationDescr descr = (AnnotationDescr)en.getValue();
                Map values = descr.getValues();
                AnnotationMetaModel am = new AnnotationMetaModel(annotationName, values);
                mm.getAnnotations().add(am);
            }
            list.add(mm);
        }
        return list;
    }
}

