/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.Modal;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.BackdropType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.workbench.screens.globals.client.resources.i18n.GlobalsEditorConstants;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class AddGlobalPopup
extends Modal {
    private static AddGlobalPopupBinder uiBinder = (AddGlobalPopupBinder)GWT.create(AddGlobalPopupBinder.class);
    @UiField
    ControlGroup aliasGroup;
    @UiField
    TextBox aliasTextBox;
    @UiField
    HelpInline aliasHelpInline;
    @UiField
    ControlGroup classNameGroup;
    @UiField
    ListBox classNameListBox;
    @UiField
    HelpInline classNameHelpInline;
    private Command callbackCommand;
    private final Command okCommand = new Command(){

        public void execute() {
            AddGlobalPopup.this.onOKButtonClick();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            AddGlobalPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);

    public AddGlobalPopup() {
        this.setTitle(GlobalsEditorConstants.INSTANCE.addGlobalPopupTitle());
        this.setBackdrop(BackdropType.STATIC);
        this.setKeyboard(true);
        this.setAnimation(true);
        this.setDynamicSafe(true);
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
        this.aliasTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                AddGlobalPopup.this.aliasGroup.setType(ControlGroupType.NONE);
                AddGlobalPopup.this.aliasHelpInline.setText("");
            }
        });
    }

    private void onOKButtonClick() {
        boolean hasError = false;
        if (this.aliasTextBox.getText() == null || this.aliasTextBox.getText().trim().isEmpty()) {
            this.aliasGroup.setType(ControlGroupType.ERROR);
            this.aliasHelpInline.setText(GlobalsEditorConstants.INSTANCE.aliasIsMandatory());
            hasError = true;
        } else {
            this.aliasGroup.setType(ControlGroupType.NONE);
        }
        if (this.classNameListBox.getSelectedIndex() < 0) {
            this.classNameGroup.setType(ControlGroupType.ERROR);
            this.classNameHelpInline.setText(GlobalsEditorConstants.INSTANCE.classNameIsMandatory());
            hasError = true;
        } else {
            this.classNameGroup.setType(ControlGroupType.NONE);
        }
        if (hasError) {
            return;
        }
        if (this.callbackCommand != null) {
            this.callbackCommand.execute();
        }
        this.hide();
    }

    public String getAlias() {
        return this.aliasTextBox.getText();
    }

    public String getClassName() {
        return this.classNameListBox.getValue();
    }

    public void setContent(Command callbackCommand, List<String> fullyQualifiedClassNames) {
        this.callbackCommand = callbackCommand;
        this.classNameListBox.clear();
        this.aliasTextBox.setText("");
        for (String className : fullyQualifiedClassNames) {
            this.classNameListBox.addItem(className);
        }
    }

    static interface AddGlobalPopupBinder
    extends UiBinder<Widget, AddGlobalPopup> {
    }
}

