/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import org.drools.workbench.screens.globals.client.editor.GlobalsEditorPresenter;
import org.drools.workbench.screens.globals.client.editor.GlobalsEditorView;
import org.drools.workbench.screens.globals.model.Global;
import org.drools.workbench.screens.globals.model.GlobalsEditorContent;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class GlobalsEditorPresenterTest {
    @Mock
    private GlobalsEditorView view;
    @Mock
    private GlobalsEditorService globalsEditorService;
    @Mock
    private KieEditorWrapperView kieView;
    @Mock
    private VersionRecordManager versionRecordManager;
    @Mock
    private OverviewWidgetPresenter overviewWidget;
    @Mock
    private ValidationService validationService;
    @Mock
    private SavePopUpPresenter savePopUpPresenter;
    @Mock
    private DeletePopUpPresenter deletePopUpPresenter;
    @Mock
    private ValidationPopup validationPopup;
    private GlobalsEditorPresenter presenter;

    @Before
    public void setUp() {
        this.presenter = new GlobalsEditorPresenter(this.view){
            {
                this.kieView = GlobalsEditorPresenterTest.this.kieView;
                this.globalsEditorService = new CallerMock((Object)GlobalsEditorPresenterTest.this.globalsEditorService);
                this.versionRecordManager = GlobalsEditorPresenterTest.this.versionRecordManager;
                this.overviewWidget = GlobalsEditorPresenterTest.this.overviewWidget;
                this.validationService = new CallerMock((Object)GlobalsEditorPresenterTest.this.validationService);
                this.savePopUpPresenter = GlobalsEditorPresenterTest.this.savePopUpPresenter;
                this.deletePopUpPresenter = GlobalsEditorPresenterTest.this.deletePopUpPresenter;
                this.validationPopup = GlobalsEditorPresenterTest.this.validationPopup;
            }
        };
    }

    @Test
    public void loadContent() {
        this.presenter.loadContent();
        ((GlobalsEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showLoading();
        ((GlobalsEditorService)Mockito.verify((Object)this.globalsEditorService, (VerificationMode)Mockito.times((int)1))).loadContent((Path)Matchers.any(Path.class));
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn(Mockito.mock(ObservablePath.class));
        GlobalsEditorContent globalsEditorContent = (GlobalsEditorContent)Mockito.mock(GlobalsEditorContent.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        Mockito.when((Object)overview.getMetadata()).thenReturn(Mockito.mock(Metadata.class));
        Mockito.when((Object)globalsEditorContent.getOverview()).thenReturn((Object)overview);
        GlobalsModel globalsModel = (GlobalsModel)Mockito.mock(GlobalsModel.class);
        Mockito.when((Object)globalsEditorContent.getModel()).thenReturn((Object)globalsModel);
        this.presenter.getModelSuccessCallback().callback((Object)globalsEditorContent);
        ((GlobalsEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContent(Mockito.anyListOf(Global.class), Mockito.anyListOf(String.class), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((GlobalsEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
    }

    @Test
    public void saveNoValidationErrors() {
        Mockito.when((Object)this.validationService.validateForSave((Path)Matchers.any(Path.class), Matchers.any(GlobalsModel.class))).thenReturn(Collections.emptyList());
        this.presenter.save();
        ((ValidationService)Mockito.verify((Object)this.validationService, (VerificationMode)Mockito.times((int)1))).validateForSave((Path)Matchers.any(Path.class), Matchers.any(GlobalsModel.class));
        ((SavePopUpPresenter)Mockito.verify((Object)this.savePopUpPresenter, (VerificationMode)Mockito.times((int)1))).show((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void saveValidationErrors() {
        Mockito.when((Object)this.validationService.validateForSave((Path)Matchers.any(Path.class), Matchers.any(GlobalsModel.class))).thenReturn(Arrays.asList(new ValidationMessage()));
        this.presenter.save();
        ((ValidationService)Mockito.verify((Object)this.validationService, (VerificationMode)Mockito.times((int)1))).validateForSave((Path)Matchers.any(Path.class), Matchers.any(GlobalsModel.class));
        ((ValidationPopup)Mockito.verify((Object)this.validationPopup, (VerificationMode)Mockito.times((int)1))).showSaveValidationMessages((Command)Matchers.any(Command.class), (Command)Matchers.any(Command.class), Mockito.anyListOf(ValidationMessage.class));
    }

    @Test
    public void deleteNoValidationErrors() {
        Mockito.when((Object)this.validationService.validateForDelete((Path)Matchers.any(Path.class))).thenReturn(Collections.emptyList());
        this.presenter.onDelete();
        ((ValidationService)Mockito.verify((Object)this.validationService, (VerificationMode)Mockito.times((int)1))).validateForDelete((Path)Matchers.any(Path.class));
        ((DeletePopUpPresenter)Mockito.verify((Object)this.deletePopUpPresenter, (VerificationMode)Mockito.times((int)1))).show((ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void deleteValidationErrors() {
        Mockito.when((Object)this.validationService.validateForDelete((Path)Matchers.any(Path.class))).thenReturn(Arrays.asList(new ValidationMessage()));
        this.presenter.onDelete();
        ((ValidationService)Mockito.verify((Object)this.validationService, (VerificationMode)Mockito.times((int)1))).validateForDelete((Path)Matchers.any(Path.class));
        ((ValidationPopup)Mockito.verify((Object)this.validationPopup, (VerificationMode)Mockito.times((int)1))).showDeleteValidationMessages((Command)Matchers.any(Command.class), (Command)Matchers.any(Command.class), Mockito.anyListOf(ValidationMessage.class));
    }
}

