/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.globals.client.editor.AddGlobalPopupView;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
public class AddGlobalPopup
implements AddGlobalPopupView.Presenter {
    private AddGlobalPopupView view;
    private Command addCommand;
    private Command cancelCommand;

    @Inject
    public AddGlobalPopup(AddGlobalPopupView view) {
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public String getAlias() {
        return this.view.getInsertedAlias();
    }

    public String getClassName() {
        return this.view.getSelectedClassName();
    }

    public void show(Command addCommand, Command cancelCommand, List<String> fullyQualifiedClassNames) {
        this.addCommand = (Command)PortablePreconditions.checkNotNull((String)"addCommand", (Object)addCommand);
        this.cancelCommand = (Command)PortablePreconditions.checkNotNull((String)"cancelCommand", (Object)cancelCommand);
        PortablePreconditions.checkNotNull((String)"fullyQualifiedClassNames", fullyQualifiedClassNames);
        this.view.clear();
        this.view.setClassNames(fullyQualifiedClassNames);
        this.view.show();
    }

    @Override
    public void onAliasInputChanged() {
        this.checkAliasValidationErrors();
    }

    @Override
    public void onClassNameSelectChanged() {
        this.checkClassNameValidationErrors();
    }

    private boolean checkAliasValidationErrors() {
        if (this.aliasValidationErrorsPresent()) {
            this.view.showAliasValidationError();
            return true;
        }
        this.view.hideAliasValidationError();
        return false;
    }

    private boolean checkClassNameValidationErrors() {
        if (this.classNameValidationErrorsPresent()) {
            this.view.showClassNameValidationError();
            return true;
        }
        this.view.hideClassNameValidationError();
        return false;
    }

    private boolean aliasValidationErrorsPresent() {
        String aliasValue = this.getAlias();
        return aliasValue == null || aliasValue.isEmpty();
    }

    private boolean classNameValidationErrorsPresent() {
        String classNameValue = this.getClassName();
        return classNameValue == null || classNameValue.isEmpty();
    }

    @Override
    public void onAddButtonClicked() {
        if (!this.checkAliasValidationErrors() && !this.checkClassNameValidationErrors()) {
            this.addCommand.execute();
            this.view.hide();
        }
    }

    @Override
    public void onCancelButtonClicked() {
        this.cancelCommand.execute();
        this.view.hide();
    }
}

