/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import elemental2.promise.Promise;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.drools.workbench.screens.globals.client.editor.GlobalsEditorView;
import org.drools.workbench.screens.globals.client.type.GlobalResourceType;
import org.drools.workbench.screens.globals.model.GlobalsEditorContent;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.callbacks.CommandErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@WorkbenchEditor(identifier="org.kie.guvnor.globals", supportedTypes={GlobalResourceType.class}, priority=101)
public class GlobalsEditorPresenter
extends KieEditor<GlobalsModel> {
    public static final String EDITOR_ID = "org.kie.guvnor.globals";
    @Inject
    protected Caller<GlobalsEditorService> globalsEditorService;
    @Inject
    protected Caller<ValidationService> validationService;
    @Inject
    protected ValidationPopup validationPopup;
    private GlobalsEditorView view;
    @Inject
    private GlobalResourceType type;
    private GlobalsModel model;

    public GlobalsEditorPresenter() {
    }

    @Inject
    public GlobalsEditorPresenter(GlobalsEditorView baseView) {
        super((KieEditorView)baseView);
        this.view = baseView;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
    }

    protected Promise<Void> makeMenuBar() {
        if (this.workbenchContext.getActiveWorkspaceProject().isPresent()) {
            WorkspaceProject activeProject = (WorkspaceProject)this.workbenchContext.getActiveWorkspaceProject().get();
            return this.projectController.canUpdateProject(activeProject).then(canUpdateProject -> {
                if (canUpdateProject.booleanValue()) {
                    ParameterizedCommand onSave = withComments -> {
                        this.saveWithComments = withComments;
                        this.saveAction();
                    };
                    this.fileMenuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(onSave)).addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.assetUpdateValidator).addRename(this.getSaveAndRename()).addDelete(this::onDelete);
                }
                this.addDownloadMenuItem(this.fileMenuBuilder);
                this.fileMenuBuilder.addValidate(this.getValidateCommand()).addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
                return this.promises.resolve();
            });
        }
        return this.promises.resolve();
    }

    protected void loadContent() {
        this.view.showLoading();
        ((GlobalsEditorService)this.globalsEditorService.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    protected Supplier<GlobalsModel> getContentSupplier() {
        return () -> this.model;
    }

    protected Caller<? extends SupportsSaveAndRename<GlobalsModel, Metadata>> getSaveAndRenameServiceCaller() {
        return this.globalsEditorService;
    }

    protected RemoteCallback<GlobalsEditorContent> getModelSuccessCallback() {
        return new RemoteCallback<GlobalsEditorContent>(){

            public void callback(GlobalsEditorContent content) {
                if (GlobalsEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                GlobalsEditorPresenter.this.model = content.getModel();
                GlobalsEditorPresenter.this.resetEditorPages(content.getOverview());
                GlobalsEditorPresenter.this.addSourcePage();
                List fullyQualifiedClassNames = content.getFullyQualifiedClassNames();
                GlobalsEditorPresenter.this.view.setContent(content.getModel().getGlobals(), fullyQualifiedClassNames, GlobalsEditorPresenter.this.isReadOnly, content.getOverview().getMetadata().isGenerated());
                GlobalsEditorPresenter.this.createOriginalHash(GlobalsEditorPresenter.this.model);
                GlobalsEditorPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    protected void onValidate(Command finished) {
        ((GlobalsEditorService)this.globalsEditorService.call((RemoteCallback)this.validationPopup.getValidationCallback(finished), (ErrorCallback)new CommandErrorCallback(finished))).validate((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model);
    }

    protected void save() {
        ParameterizedCommand doSave = commitMessage -> {
            this.baseView.showSaving();
            ((GlobalsEditorService)this.globalsEditorService.call(this.getSaveSuccessCallback(this.model.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model, (Object)this.metadata, commitMessage);
            this.concurrentUpdateSessionInfo = null;
        };
        Command showPopUp = () -> this.savePopUpPresenter.show((Path)this.versionRecordManager.getCurrentPath(), doSave);
        Command command = () -> {
            if (this.saveWithComments) {
                showPopUp.execute();
            } else {
                doSave.execute((Object)"");
            }
        };
        ((ValidationService)this.validationService.call(obj -> {
            List validationMessages = (List)obj;
            if (validationMessages.isEmpty()) {
                command.execute();
            } else {
                this.validationPopup.showSaveValidationMessages(command, () -> {}, validationMessages);
            }
        })).validateForSave((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model);
        this.concurrentUpdateSessionInfo = null;
    }

    protected void onDelete() {
        ((ValidationService)this.validationService.call(validationMessages -> {
            if (((List)validationMessages).isEmpty()) {
                this.showDeletePopup((Path)this.getVersionRecordManager().getCurrentPath());
            } else {
                this.validationPopup.showDeleteValidationMessages(() -> this.showDeletePopup((Path)this.versionRecordManager.getCurrentPath()), () -> {}, (List)validationMessages);
            }
        })).validateForDelete((Path)this.versionRecordManager.getCurrentPath());
    }

    private void showDeletePopup(Path path) {
        this.deletePopUpPresenter.show((Validator)this.assetUpdateValidator, comment -> {
            this.view.showBusyIndicator(org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants.INSTANCE.Deleting());
            ((GlobalsEditorService)this.globalsEditorService.call(this.getDeleteSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).delete(path, "delete");
        });
    }

    private RemoteCallback<Path> getDeleteSuccessCallback() {
        return response -> {
            this.view.hideBusyIndicator();
            this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemDeletedSuccessfully()));
        };
    }

    public void onSourceTabSelected() {
        ((GlobalsEditorService)this.globalsEditorService.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String source) {
                GlobalsEditorPresenter.this.updateSource(source);
            }
        })).toSource((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model);
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
        super.onClose();
    }

    protected String getEditorIdentifier() {
        return EDITOR_ID;
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.model);
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        super.getMenus(menusConsumer);
    }
}

