/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.drools.workbench.screens.globals.client.editor.GlobalsEditorPresenter;
import org.drools.workbench.screens.globals.client.editor.GlobalsEditorView;
import org.drools.workbench.screens.globals.model.Global;
import org.drools.workbench.screens.globals.model.GlobalsEditorContent;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilderImpl;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.validation.AssetUpdateValidator;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.promise.SyncPromises;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class GlobalsEditorPresenterTest {
    @Mock
    private GlobalsEditorView view;
    @Mock
    private GlobalsEditorService globalsEditorService;
    @Mock
    private KieEditorWrapperView kieView;
    @Mock
    private VersionRecordManager versionRecordManager;
    @Mock
    private OverviewWidgetPresenter overviewWidget;
    @Mock
    private ValidationService validationService;
    @Mock
    private SavePopUpPresenter savePopUpPresenter;
    @Mock
    private DeletePopUpPresenter deletePopUpPresenter;
    @Mock
    private ValidationPopup validationPopup;
    @Mock
    private BasicFileMenuBuilder menuBuilder;
    @Spy
    @InjectMocks
    private FileMenuBuilderImpl fileMenuBuilder;
    @Mock
    private ProjectController projectController;
    @Mock
    private WorkspaceProjectContext workbenchContext;
    @Mock
    private AssetUpdateValidator assetUpdateValidator;
    @Mock
    private AlertsButtonMenuItemBuilder alertsButtonMenuItemBuilder;
    @Mock
    protected MenuItem alertsButtonMenuItem;
    private Promises promises;
    private GlobalsEditorPresenter presenter;

    @Before
    public void setUp() {
        this.promises = new SyncPromises();
        Mockito.when((Object)this.alertsButtonMenuItemBuilder.build()).thenReturn((Object)this.alertsButtonMenuItem);
        this.presenter = (GlobalsEditorPresenter)Mockito.spy((Object)new GlobalsEditorPresenter(this.view){
            {
                this.kieView = GlobalsEditorPresenterTest.this.kieView;
                this.globalsEditorService = new CallerMock((Object)GlobalsEditorPresenterTest.this.globalsEditorService);
                this.versionRecordManager = GlobalsEditorPresenterTest.this.versionRecordManager;
                this.overviewWidget = GlobalsEditorPresenterTest.this.overviewWidget;
                this.validationService = new CallerMock((Object)GlobalsEditorPresenterTest.this.validationService);
                this.savePopUpPresenter = GlobalsEditorPresenterTest.this.savePopUpPresenter;
                this.deletePopUpPresenter = GlobalsEditorPresenterTest.this.deletePopUpPresenter;
                this.validationPopup = GlobalsEditorPresenterTest.this.validationPopup;
                this.fileMenuBuilder = GlobalsEditorPresenterTest.this.fileMenuBuilder;
                this.projectController = GlobalsEditorPresenterTest.this.projectController;
                this.workbenchContext = GlobalsEditorPresenterTest.this.workbenchContext;
                this.versionRecordManager = GlobalsEditorPresenterTest.this.versionRecordManager;
                this.assetUpdateValidator = GlobalsEditorPresenterTest.this.assetUpdateValidator;
                this.alertsButtonMenuItemBuilder = GlobalsEditorPresenterTest.this.alertsButtonMenuItemBuilder;
                this.promises = GlobalsEditorPresenterTest.this.promises;
            }

            protected Command getSaveAndRename() {
                return (Command)Mockito.mock(Command.class);
            }
        });
        ((GlobalsEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).addDownloadMenuItem((FileMenuBuilder)Matchers.any());
    }

    @Test
    public void loadContent() {
        this.presenter.loadContent();
        ((GlobalsEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showLoading();
        ((GlobalsEditorService)Mockito.verify((Object)this.globalsEditorService, (VerificationMode)Mockito.times((int)1))).loadContent((Path)Matchers.any());
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn(Mockito.mock(ObservablePath.class));
        GlobalsEditorContent globalsEditorContent = (GlobalsEditorContent)Mockito.mock(GlobalsEditorContent.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        Mockito.when((Object)overview.getMetadata()).thenReturn(Mockito.mock(Metadata.class));
        Mockito.when((Object)globalsEditorContent.getOverview()).thenReturn((Object)overview);
        GlobalsModel globalsModel = (GlobalsModel)Mockito.mock(GlobalsModel.class);
        Mockito.when((Object)globalsEditorContent.getModel()).thenReturn((Object)globalsModel);
        this.presenter.getModelSuccessCallback().callback((Object)globalsEditorContent);
        ((GlobalsEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContent(Matchers.anyListOf(Global.class), Matchers.anyListOf(String.class), Matchers.anyBoolean(), Matchers.anyBoolean());
        ((GlobalsEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
    }

    @Test
    public void saveNoValidationErrors() {
        Mockito.when((Object)this.validationService.validateForSave((Path)Matchers.any(Path.class), Matchers.any(GlobalsModel.class))).thenReturn(Collections.emptyList());
        this.presenter.save();
        ((ValidationService)Mockito.verify((Object)this.validationService, (VerificationMode)Mockito.times((int)1))).validateForSave((Path)Matchers.any(), Matchers.any());
        ((SavePopUpPresenter)Mockito.verify((Object)this.savePopUpPresenter, (VerificationMode)Mockito.times((int)1))).show((Path)Matchers.any(), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void saveValidationErrors() {
        Mockito.when((Object)this.validationService.validateForSave((Path)Matchers.any(), Matchers.any())).thenReturn(Arrays.asList(new ValidationMessage()));
        this.presenter.save();
        ((ValidationService)Mockito.verify((Object)this.validationService, (VerificationMode)Mockito.times((int)1))).validateForSave((Path)Matchers.any(), Matchers.any());
        ((ValidationPopup)Mockito.verify((Object)this.validationPopup, (VerificationMode)Mockito.times((int)1))).showSaveValidationMessages((Command)Matchers.any(Command.class), (Command)Matchers.any(Command.class), Matchers.anyListOf(ValidationMessage.class));
    }

    @Test
    public void deleteNoValidationErrors() {
        Mockito.when((Object)this.validationService.validateForDelete((Path)Matchers.any(Path.class))).thenReturn(Collections.emptyList());
        this.presenter.onDelete();
        ((ValidationService)Mockito.verify((Object)this.validationService, (VerificationMode)Mockito.times((int)1))).validateForDelete((Path)Matchers.any());
        ((DeletePopUpPresenter)Mockito.verify((Object)this.deletePopUpPresenter, (VerificationMode)Mockito.times((int)1))).show((Validator)Matchers.eq((Object)this.assetUpdateValidator), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void deleteValidationErrors() {
        Mockito.when((Object)this.validationService.validateForDelete((Path)Matchers.any())).thenReturn(Arrays.asList(new ValidationMessage()));
        this.presenter.onDelete();
        ((ValidationService)Mockito.verify((Object)this.validationService, (VerificationMode)Mockito.times((int)1))).validateForDelete((Path)Matchers.any());
        ((ValidationPopup)Mockito.verify((Object)this.validationPopup, (VerificationMode)Mockito.times((int)1))).showDeleteValidationMessages((Command)Matchers.any(Command.class), (Command)Matchers.any(Command.class), Matchers.anyListOf(ValidationMessage.class));
    }

    @Test
    public void testMakeMenuBar() {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)true)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Matchers.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addSave((MenuItem)Mockito.any());
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addCopy((Path)Mockito.any(), (Validator)Matchers.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addRename((Command)Matchers.any(Command.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addDelete((Command)Matchers.any(Command.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
        ((GlobalsEditorPresenter)Mockito.verify((Object)this.presenter)).addDownloadMenuItem((FileMenuBuilder)this.fileMenuBuilder);
    }

    @Test
    public void testMakeMenuBarWithoutUpdateProjectPermission() {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)false)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Matchers.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addSave((MenuItem)Matchers.any(MenuItem.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addCopy((Path)Matchers.any(Path.class), (Validator)Matchers.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addRename((Path)Matchers.any(Path.class), (Validator)Matchers.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addDelete((Command)Matchers.any(Command.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
    }
}

