/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import org.drools.workbench.screens.globals.client.editor.GlobalsEditorPresenter;
import org.drools.workbench.screens.globals.client.editor.GlobalsEditorView;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.gwtbootstrap3.client.ui.Modal;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.test.MockProvider;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.java.nio.IOException;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Modal.class})
public class GlobalsEditorPresenterValidationTest {
    @Mock
    GlobalsEditorService service;
    GlobalsEditorPresenter presenter;

    @Before
    public void setUp() throws Exception {
        this.presenter = new GlobalsEditorPresenter((GlobalsEditorView)Mockito.mock(GlobalsEditorView.class)){
            {
                this.globalsEditorService = new CallerMock((Object)GlobalsEditorPresenterValidationTest.this.service);
                this.versionRecordManager = (VersionRecordManager)Mockito.mock(VersionRecordManager.class);
                this.validationPopup = MockProvider.getMockValidationPopup();
            }
        };
    }

    @Test
    public void commandIsCalled() throws Exception {
        ((GlobalsEditorService)Mockito.doReturn(new ArrayList()).when((Object)this.service)).validate((Path)Mockito.any(Path.class), (Object)((GlobalsModel)Mockito.any(GlobalsModel.class)));
        Command afterValidation = (Command)Mockito.mock(Command.class);
        this.presenter.onValidate(afterValidation);
        ((Command)Mockito.verify((Object)afterValidation)).execute();
    }

    @Test
    public void callFailsAndCommandIsCalled() throws Exception {
        ((GlobalsEditorService)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.service)).validate((Path)Mockito.any(Path.class), (Object)((GlobalsModel)Mockito.any(GlobalsModel.class)));
        Command afterValidation = (Command)Mockito.mock(Command.class);
        this.presenter.onValidate(afterValidation);
        ((Command)Mockito.verify((Object)afterValidation)).execute();
    }
}

