/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.shared;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.shared.DefaultGuidedDecisionTableLinkManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultGuidedDecisionTableLinkManagerTest {
    private DefaultGuidedDecisionTableLinkManager manager;

    @Before
    public void setup() {
        DefaultGuidedDecisionTableLinkManager wrapped = new DefaultGuidedDecisionTableLinkManager();
        this.manager = (DefaultGuidedDecisionTableLinkManager)Mockito.spy((Object)wrapped);
    }

    @Test
    public void onlyOneDecisionTableThereforeNoLinks() {
        this.manager.link(new GuidedDecisionTable52(), null, (s, t) -> Assert.fail((String)"There should be no links"));
    }

    @Test
    public void fieldConstraintLinksToActionUpdateField() {
        GuidedDecisionTable52 dt1 = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("$f");
        p1.setFactType("Fact");
        ConditionCol52 p1c1 = new ConditionCol52();
        p1c1.setFactField("field");
        p1.getChildColumns().add(p1c1);
        dt1.getConditions().add(p1);
        ActionSetFieldCol52 asf = new ActionSetFieldCol52();
        asf.setBoundName("$f");
        asf.setFactField("field");
        dt1.getActionCols().add(asf);
        GuidedDecisionTable52 dt2 = new GuidedDecisionTable52();
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("$f");
        p2.setFactType("Fact");
        ConditionCol52 p2c1 = new ConditionCol52();
        p2c1.setFactField("field");
        p2.getChildColumns().add(p2c1);
        dt2.getConditions().add(p2);
        this.manager.link(dt1, dt2, (s, t) -> {
            Assert.assertEquals((long)3L, (long)s);
            Assert.assertEquals((long)2L, (long)t);
        });
    }

    @Test
    public void fieldConstraintLinksToActionInsertFactField() {
        GuidedDecisionTable52 dt1 = new GuidedDecisionTable52();
        ActionInsertFactCol52 aif = new ActionInsertFactCol52();
        aif.setFactType("Fact");
        aif.setFactField("field");
        dt1.getActionCols().add(aif);
        GuidedDecisionTable52 dt2 = new GuidedDecisionTable52();
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("$f");
        p2.setFactType("Fact");
        ConditionCol52 p2c1 = new ConditionCol52();
        p2c1.setFactField("field");
        p2.getChildColumns().add(p2c1);
        dt2.getConditions().add(p2);
        this.manager.link(dt1, dt2, (s, t) -> {
            Assert.assertEquals((long)2L, (long)s);
            Assert.assertEquals((long)2L, (long)t);
        });
    }

    @Test
    public void fieldConstraintWithActionBRLFragmentFieldWithoutTemplateKey() {
        GuidedDecisionTable52 dt1 = new GuidedDecisionTable52();
        BRLActionColumn brl = new BRLActionColumn();
        final ActionInsertFact aif = new ActionInsertFact();
        aif.setFactType("Fact");
        aif.addFieldValue(new ActionFieldValue(){
            {
                this.setField("field");
                this.setValue("10");
                this.setNature(1);
            }
        });
        brl.setDefinition((List)new ArrayList<IAction>(){
            {
                this.add(aif);
            }
        });
        brl.getChildColumns().add(new BRLActionVariableColumn("", "Boolean"));
        dt1.getActionCols().add(brl);
        GuidedDecisionTable52 dt2 = new GuidedDecisionTable52();
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("$f");
        p2.setFactType("Fact");
        ConditionCol52 p2c1 = new ConditionCol52();
        p2c1.setFactField("field");
        p2.getChildColumns().add(p2c1);
        dt2.getConditions().add(p2);
        this.manager.link(dt1, dt2, (s, t) -> {
            Assert.assertEquals((long)2L, (long)s);
            Assert.assertEquals((long)2L, (long)t);
        });
    }

    @Test
    public void fieldConstraintWithActionBRLFragmentFieldWithTemplateKey() {
        GuidedDecisionTable52 dt1 = new GuidedDecisionTable52();
        BRLActionColumn brl = new BRLActionColumn();
        final ActionInsertFact aif = new ActionInsertFact("Fact");
        aif.addFieldValue(new ActionFieldValue(){
            {
                this.setField("field");
                this.setValue("10");
                this.setType("String");
                this.setNature(7);
            }
        });
        brl.setDefinition((List)new ArrayList<IAction>(){
            {
                this.add(aif);
            }
        });
        brl.getChildColumns().add(new BRLActionVariableColumn("$f", "String", "Fact", "field"));
        dt1.getActionCols().add(brl);
        GuidedDecisionTable52 dt2 = new GuidedDecisionTable52();
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("$f");
        p2.setFactType("Fact");
        ConditionCol52 p2c1 = new ConditionCol52();
        p2c1.setFactField("field");
        p2.getChildColumns().add(p2c1);
        dt2.getConditions().add(p2);
        this.manager.link(dt1, dt2, (s, t) -> {
            Assert.assertEquals((long)2L, (long)s);
            Assert.assertEquals((long)2L, (long)t);
        });
    }
}

