/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.shared;

import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableLinkManager;

public class DefaultGuidedDecisionTableLinkManager
implements GuidedDecisionTableLinkManager {
    @Override
    public void link(GuidedDecisionTable52 model, GuidedDecisionTable52 otherModel, GuidedDecisionTableLinkManager.LinkFoundCallback callback) {
        if (model == null) {
            return;
        }
        if (otherModel == null) {
            return;
        }
        if (callback == null) {
            return;
        }
        BRLRuleModel helper = new BRLRuleModel(model);
        for (CompositeColumn otherDecisionTableConditions : otherModel.getConditions()) {
            int targetColumnIndex;
            int sourceColumnIndex;
            ActionCol52 linkedActionColumn;
            String fieldName;
            String factType;
            if (otherDecisionTableConditions instanceof Pattern52) {
                Pattern52 otherDecisionTablePattern = (Pattern52)otherDecisionTableConditions;
                for (ConditionCol52 otherDecisionTableCondition : otherDecisionTablePattern.getChildColumns()) {
                    factType = otherDecisionTablePattern.getFactType();
                    linkedActionColumn = this.getLinkedActionColumn(factType, fieldName = otherDecisionTableCondition.getFactField(), model, helper);
                    if (linkedActionColumn == null) continue;
                    sourceColumnIndex = model.getExpandedColumns().indexOf(linkedActionColumn);
                    targetColumnIndex = otherModel.getExpandedColumns().indexOf(otherDecisionTableCondition);
                    callback.link(sourceColumnIndex, targetColumnIndex);
                }
                continue;
            }
            if (!(otherDecisionTableConditions instanceof BRLConditionColumn)) continue;
            BRLConditionColumn fragment = (BRLConditionColumn)otherDecisionTableConditions;
            for (BRLConditionVariableColumn var : fragment.getChildColumns()) {
                factType = var.getFactType();
                linkedActionColumn = this.getLinkedActionColumn(factType, fieldName = var.getFactField(), model, helper);
                if (linkedActionColumn == null) continue;
                sourceColumnIndex = model.getExpandedColumns().indexOf(linkedActionColumn);
                targetColumnIndex = otherModel.getExpandedColumns().indexOf(var);
                callback.link(sourceColumnIndex, targetColumnIndex);
            }
        }
    }

    private ActionCol52 getLinkedActionColumn(String factType, String fieldName, GuidedDecisionTable52 model, BRLRuleModel helper) {
        if (factType == null || fieldName == null) {
            return null;
        }
        for (ActionCol52 ac : model.getActionCols()) {
            if (ac instanceof ActionInsertFactCol52) {
                ActionInsertFactCol52 aif = (ActionInsertFactCol52)ac;
                if (!factType.equals(aif.getFactType()) || !fieldName.equals(aif.getFactField())) continue;
                return ac;
            }
            if (ac instanceof ActionSetFieldCol52) {
                ActionSetFieldCol52 asf = (ActionSetFieldCol52)ac;
                String binding = asf.getBoundName();
                String asfFactType = helper.getLHSBindingType(binding);
                if (!factType.equals(asfFactType) || !fieldName.equals(asf.getFactField())) continue;
                return ac;
            }
            if (!(ac instanceof BRLActionColumn)) continue;
            BRLActionColumn fragment = (BRLActionColumn)ac;
            for (BRLActionVariableColumn var : fragment.getChildColumns()) {
                if (!factType.equals(var.getFactType()) || !fieldName.equals(var.getFactField())) continue;
                return ac;
            }
        }
        return null;
    }
}

