/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDecisionTableModelVisitor;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.workitems.service.WorkItemsEditorService;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.file.CopyService;
import org.guvnor.common.services.shared.file.DeleteService;
import org.guvnor.common.services.shared.file.RenameService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.file.DslFileFilter;
import org.kie.workbench.common.services.backend.file.GlobalsFileFilter;
import org.kie.workbench.common.services.backend.source.SourceServices;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class GuidedDecisionTableEditorServiceImpl
implements GuidedDecisionTableEditorService {
    private static final JavaFileFilter FILTER_JAVA = new JavaFileFilter();
    private static final DslFileFilter FILTER_DSLS = new DslFileFilter();
    private static final GlobalsFileFilter FILTER_GLOBALS = new GlobalsFileFilter();
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private Identity identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private SourceServices sourceServices;
    @Inject
    private WorkItemsEditorService workItemsService;
    @Inject
    private ProjectService projectService;
    @Inject
    private GenericValidator genericValidator;

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, GuidedDecisionTable52 content, String comment) {
        try {
            Package pkg = this.projectService.resolvePackage(context);
            String packageName = pkg == null ? null : pkg.getPackageName();
            content.setPackageName(packageName);
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, GuidedDTXMLPersistence.getInstance().marshal(content), new OpenOption[]{this.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GuidedDecisionTable52 load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
            return GuidedDTXMLPersistence.getInstance().unmarshal(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GuidedDecisionTableEditorContent loadContent(org.uberfire.backend.vfs.Path path) {
        try {
            GuidedDecisionTable52 model = this.load(path);
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
            GuidedDecisionTableModelVisitor visitor = new GuidedDecisionTableModelVisitor(model);
            DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, visitor.getConsumedModelClasses());
            Set workItemDefinitions = this.workItemsService.loadWorkItemDefinitions(path);
            return new GuidedDecisionTableEditorContent(model, workItemDefinitions, dataModel);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public PackageDataModelOracleBaselinePayload loadDataModel(org.uberfire.backend.vfs.Path path) {
        try {
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
            DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, new HashSet());
            return dataModel;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, GuidedDecisionTable52 model, Metadata metadata, String comment) {
        try {
            Package pkg = this.projectService.resolvePackage(resource);
            String packageName = pkg == null ? null : pkg.getPackageName();
            model.setPackageName(packageName);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), GuidedDTXMLPersistence.getInstance().marshal(model), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String toSource(org.uberfire.backend.vfs.Path path, GuidedDecisionTable52 model) {
        try {
            return this.sourceServices.getServiceFor(Paths.convert((org.uberfire.backend.vfs.Path)path)).getSource(Paths.convert((org.uberfire.backend.vfs.Path)path), (Object)model);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, GuidedDecisionTable52 content) {
        try {
            return this.genericValidator.validate(path, (InputStream)new ByteArrayInputStream(GuidedDTXMLPersistence.getInstance().marshal(content).getBytes()), new DirectoryStream.Filter[]{FILTER_JAVA, FILTER_GLOBALS, FILTER_DSLS});
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return co;
    }
}

