/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.Version;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.indexing.GuidedDecisionTableFactory;
import org.drools.workbench.screens.guided.dtable.backend.server.indexing.TestGuidedDecisionTableFileIndexer;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.kie.workbench.common.services.refactoring.backend.server.query.QueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexGuidedDecisionTableBRLFragmentActionsTest
extends BaseIndexingTest<GuidedDTableResourceTypeDefinition> {
    @Test
    public void testIndexGuidedDecisionTableBRLFragmentActions() throws IOException, InterruptedException {
        int i;
        Path path = this.basePath.resolve("dtable1.gdst");
        GuidedDecisionTable52 model = GuidedDecisionTableFactory.makeTableWithBRLFragmentActionCol("org.drools.workbench.screens.guided.dtable.backend.server.indexing", (Collection<Import>)new ArrayList<Import>(){
            {
                this.add(new Import("org.drools.workbench.screens.guided.dtable.backend.server.indexing.classes.Applicant"));
                this.add(new Import("org.drools.workbench.screens.guided.dtable.backend.server.indexing.classes.Mortgage"));
            }
        }, "dtable1");
        String xml = GuidedDTXMLPersistence.getInstance().marshal(model);
        this.ioService().write(path, xml, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexGuidedDecisionTableBRLFragmentActionsTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        Query query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.guided.dtable.backend.server.indexing.classes.Applicant")).build();
        searcher.search(query, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        ArrayList<KObject> results = new ArrayList<KObject>();
        for (i = 0; i < hits.length; ++i) {
            results.add(org.uberfire.ext.metadata.backend.lucene.util.KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc)));
        }
        this.assertContains(results, path);
        ((LuceneIndex)index).nrtRelease(searcher);
        searcher = ((LuceneIndex)index).nrtSearcher();
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.guided.dtable.backend.server.indexing.classes.Mortgage")).build();
        searcher.search(query, (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        results = new ArrayList();
        for (i = 0; i < hits.length; ++i) {
            results.add(org.uberfire.ext.metadata.backend.lucene.util.KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc)));
        }
        this.assertContains(results, path);
        ((LuceneIndex)index).nrtRelease(searcher);
    }

    protected TestIndexer getIndexer() {
        return new TestGuidedDecisionTableFileIndexer();
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("ruleAttribute", new RuleAttributeNameAnalyzer(Version.LUCENE_40));
            }
        };
    }

    protected GuidedDTableResourceTypeDefinition getResourceTypeDefinition() {
        return new GuidedDTableResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

