/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.event.Event;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDecisionTableEditorServiceImpl;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.drools.workbench.screens.workitems.service.WorkItemsEditorService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedDecisionTableEditorServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private CopyService copyService;
    @Mock
    private DeleteService deleteService;
    @Mock
    private RenameService renameService;
    @Mock
    private DataModelService dataModelService;
    @Mock
    private WorkItemsEditorService workItemsService;
    @Mock
    private KieProjectService projectService;
    @Mock
    private Event<ResourceOpenedEvent> resourceOpenedEvent = new EventSourceMock();
    @Mock
    private GenericValidator genericValidator;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    private GuidedDTableResourceTypeDefinition resourceType = new GuidedDTableResourceTypeDefinition();
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private KieProject kieProject;
    private GuidedDecisionTableEditorServiceImpl service;
    private final List<Path> resolvedPaths = new ArrayList<Path>();

    @Before
    public void setup() {
        this.service = new GuidedDecisionTableEditorServiceImpl(this.ioService, this.copyService, this.deleteService, this.renameService, this.dataModelService, this.workItemsService, this.projectService, this.resourceOpenedEvent, this.genericValidator, this.commentedOptionFactory, this.resourceType, this.sessionInfo);
        Mockito.when((Object)this.projectService.resolveProject((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)this.kieProject);
        Mockito.when((Object)this.kieProject.getRootPath()).thenReturn((Object)PathFactory.newPath((String)"project", (String)"default://project/"));
        this.resolvedPaths.clear();
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(Path.class))).thenReturn((Object)new DirectoryStream<Path>(){

            public void close() throws IOException {
            }

            public Iterator<Path> iterator() {
                return GuidedDecisionTableEditorServiceImplTest.this.resolvedPaths.iterator();
            }
        });
    }

    @Test
    public void testListDecisionTablesInPackage() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://project/src/main/resources/dtable1.gdst");
        this.resolvedPaths.add(this.makeNioPath("default://project/src/main/resources/dtable1.gdst"));
        this.resolvedPaths.add(this.makeNioPath("default://project/src/main/resources/dtable2.gdst"));
        this.resolvedPaths.add(this.makeNioPath("default://project/src/main/resources/dtable3.gdst"));
        this.resolvedPaths.add(this.makeNioPath("default://project/src/main/resources/pupa.smurf"));
        List paths = this.service.listDecisionTablesInProject(path);
        Assert.assertNotNull((Object)paths);
        Assert.assertEquals((long)3L, (long)paths.size());
        HashSet<String> fileNames = new HashSet<String>();
        for (org.uberfire.backend.vfs.Path p : paths) {
            fileNames.add(p.getFileName());
        }
        Assert.assertTrue((boolean)fileNames.contains("dtable1.gdst"));
        Assert.assertTrue((boolean)fileNames.contains("dtable2.gdst"));
        Assert.assertTrue((boolean)fileNames.contains("dtable3.gdst"));
    }

    private Path makeNioPath(String uri) {
        return Paths.get((String)uri, (String[])new String[0]);
    }
}

