/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.indexing.GuidedDecisionTableFactory;
import org.drools.workbench.screens.guided.dtable.backend.server.indexing.TestGuidedDecisionTableFileIndexer;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.BasicQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexGuidedDecisionTableActionsTest
extends BaseIndexingTest<GuidedDTableResourceTypeDefinition> {
    @Test
    public void testIndexGuidedDecisionTableActions() throws IOException, InterruptedException {
        Path path = this.basePath.resolve("dtable1.gdst");
        GuidedDecisionTable52 model = GuidedDecisionTableFactory.makeTableWithActionCol("org.drools.workbench.screens.guided.dtable.backend.server.indexing", (Collection<Import>)new ArrayList<Import>(){
            {
                this.add(new Import("org.drools.workbench.screens.guided.dtable.backend.server.indexing.classes.Applicant"));
            }
        }, "dtable1");
        String xml = GuidedDTXMLPersistence.getInstance().marshal(model);
        this.ioService().write(path, xml, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexGuidedDecisionTableActionsTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        Query query = new BasicQueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.guided.dtable.backend.server.indexing.classes.Applicant")).build();
        this.searchFor(index, query, 1, new Path[]{path});
    }

    protected TestIndexer getIndexer() {
        return new TestGuidedDecisionTableFileIndexer();
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("ruleAttribute", new RuleAttributeNameAnalyzer());
            }
        };
    }

    protected GuidedDTableResourceTypeDefinition getResourceTypeDefinition() {
        return new GuidedDTableResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

