/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDecisionTableModelVisitor;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.drools.workbench.screens.workitems.service.WorkItemsEditorService;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.FileExtensionFilter;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.file.DRLFileFilter;
import org.kie.workbench.common.services.backend.file.DSLFileFilter;
import org.kie.workbench.common.services.backend.file.DSLRFileFilter;
import org.kie.workbench.common.services.backend.file.GlobalsFileFilter;
import org.kie.workbench.common.services.backend.file.RDRLFileFilter;
import org.kie.workbench.common.services.backend.file.RDSLRFileFilter;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class GuidedDecisionTableEditorServiceImpl
extends KieService<GuidedDecisionTableEditorContent>
implements GuidedDecisionTableEditorService {
    private static final JavaFileFilter FILTER_JAVA = new JavaFileFilter();
    private static final DRLFileFilter FILTER_DRL = new DRLFileFilter();
    private static final DSLRFileFilter FILTER_DSLR = new DSLRFileFilter();
    private static final DSLFileFilter FILTER_DSL = new DSLFileFilter();
    private static final RDRLFileFilter FILTER_RDRL = new RDRLFileFilter();
    private static final RDSLRFileFilter FILTER_RDSLR = new RDSLRFileFilter();
    private static final GlobalsFileFilter FILTER_GLOBAL = new GlobalsFileFilter();
    private static final FileExtensionFilter FILTER_GUIDED_DECISION_TABLES = new FileExtensionFilter(".gdst");
    private IOService ioService;
    private CopyService copyService;
    private DeleteService deleteService;
    private RenameService renameService;
    private DataModelService dataModelService;
    private WorkItemsEditorService workItemsService;
    private KieProjectService projectService;
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    private GenericValidator genericValidator;
    private CommentedOptionFactory commentedOptionFactory;
    private GuidedDTableResourceTypeDefinition resourceType;
    private SafeSessionInfo safeSessionInfo;

    public GuidedDecisionTableEditorServiceImpl() {
    }

    @Inject
    public GuidedDecisionTableEditorServiceImpl(@Named(value="ioStrategy") IOService ioService, CopyService copyService, DeleteService deleteService, RenameService renameService, DataModelService dataModelService, WorkItemsEditorService workItemsService, KieProjectService projectService, Event<ResourceOpenedEvent> resourceOpenedEvent, GenericValidator genericValidator, CommentedOptionFactory commentedOptionFactory, GuidedDTableResourceTypeDefinition resourceType, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.copyService = copyService;
        this.deleteService = deleteService;
        this.renameService = renameService;
        this.dataModelService = dataModelService;
        this.workItemsService = workItemsService;
        this.projectService = projectService;
        this.resourceOpenedEvent = resourceOpenedEvent;
        this.genericValidator = genericValidator;
        this.commentedOptionFactory = commentedOptionFactory;
        this.resourceType = resourceType;
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, GuidedDecisionTable52 content, String comment) {
        try {
            Package pkg = this.projectService.resolvePackage(context);
            String packageName = pkg == null ? null : pkg.getPackageName();
            content.setPackageName(packageName);
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, GuidedDTXMLPersistence.getInstance().marshal(content), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GuidedDecisionTable52 load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return GuidedDTXMLPersistence.getInstance().unmarshal(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GuidedDecisionTableEditorContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (GuidedDecisionTableEditorContent)super.loadContent(path);
    }

    protected GuidedDecisionTableEditorContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        GuidedDecisionTable52 model = this.load(path);
        PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
        PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
        GuidedDecisionTableModelVisitor visitor = new GuidedDecisionTableModelVisitor(model);
        Set<String> consumedFQCNs = visitor.getConsumedModelClasses();
        consumedFQCNs.addAll(oracle.getPackageGlobals().values());
        DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, consumedFQCNs);
        Set workItemDefinitions = this.workItemsService.loadWorkItemDefinitions(path);
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, (SessionInfo)this.safeSessionInfo));
        return new GuidedDecisionTableEditorContent(model, workItemDefinitions, overview, dataModel);
    }

    public PackageDataModelOracleBaselinePayload loadDataModel(org.uberfire.backend.vfs.Path path) {
        try {
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
            DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, new HashSet());
            return dataModel;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, GuidedDecisionTable52 model, Metadata metadata, String comment) {
        try {
            Package pkg = this.projectService.resolvePackage(resource);
            String packageName = pkg == null ? null : pkg.getPackageName();
            model.setPackageName(packageName);
            Metadata currentMetadata = this.metadataService.getMetadata(resource);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), GuidedDTXMLPersistence.getInstance().marshal(model), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            this.fireMetadataSocialEvents(resource, currentMetadata, metadata);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        try {
            return this.copyService.copy(path, newName, targetDirectory, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String toSource(org.uberfire.backend.vfs.Path path, GuidedDecisionTable52 model) {
        return this.sourceServices.getServiceFor(Paths.convert((org.uberfire.backend.vfs.Path)path)).getSource(Paths.convert((org.uberfire.backend.vfs.Path)path), (Object)model);
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, GuidedDecisionTable52 content) {
        try {
            return this.genericValidator.validate(path, (InputStream)new ByteArrayInputStream(GuidedDTXMLPersistence.getInstance().marshal(content).getBytes(Charsets.UTF_8)), new DirectoryStream.Filter[]{FILTER_JAVA, FILTER_DRL, FILTER_DSLR, FILTER_DSL, FILTER_RDRL, FILTER_RDSLR, FILTER_GLOBAL});
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<org.uberfire.backend.vfs.Path> listDecisionTablesInProject(org.uberfire.backend.vfs.Path path) {
        try {
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                return Collections.emptyList();
            }
            org.uberfire.backend.vfs.Path projectRoot = project.getRootPath();
            Path nioProjectRoot = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
            Path nioProjectResourcesRoot = nioProjectRoot.resolve("src/main/resources");
            List<org.uberfire.backend.vfs.Path> paths = this.findDecisionTables(nioProjectResourcesRoot);
            return paths;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private List<org.uberfire.backend.vfs.Path> findDecisionTables(Path nioRootPath) {
        ArrayList<org.uberfire.backend.vfs.Path> paths = new ArrayList<org.uberfire.backend.vfs.Path>();
        DirectoryStream directoryStream = this.ioService.newDirectoryStream(nioRootPath);
        for (Path nioPath : directoryStream) {
            if (Files.isDirectory((Path)nioPath, (LinkOption[])new LinkOption[0])) {
                paths.addAll(this.findDecisionTables(nioPath));
                continue;
            }
            org.uberfire.backend.vfs.Path path = Paths.convert((Path)nioPath);
            if (!this.resourceType.accept(path)) continue;
            paths.add(path);
        }
        return paths;
    }
}

