/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.rule.backend.server.GuidedRuleModelVisitor;
import org.uberfire.commons.validation.PortablePreconditions;

public class GuidedDecisionTableModelVisitor {
    private final GuidedDecisionTable52 model;
    private final String packageName;
    private final Imports imports;

    public GuidedDecisionTableModelVisitor(GuidedDecisionTable52 model) {
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.packageName = model.getPackageName();
        this.imports = model.getImports();
    }

    public Set<String> getConsumedModelClasses() {
        List definition;
        HashSet<String> factTypes = new HashSet<String>();
        for (CompositeColumn cc : this.model.getPatterns()) {
            if (cc instanceof BRLConditionColumn) {
                definition = ((BRLConditionColumn)cc).getDefinition();
                factTypes.addAll(this.getConditionFactTypesFromRuleModel(definition));
                continue;
            }
            if (!(cc instanceof Pattern52)) continue;
            factTypes.add(((Pattern52)cc).getFactType());
        }
        for (ActionCol52 c : this.model.getActionCols()) {
            if (c instanceof BRLActionColumn) {
                definition = ((BRLActionColumn)c).getDefinition();
                factTypes.addAll(this.getActionFactTypesFromRuleModel(definition));
                continue;
            }
            if (!(c instanceof ActionInsertFactCol52)) continue;
            factTypes.add(((ActionInsertFactCol52)c).getFactType());
        }
        HashSet<String> fullyQualifiedClassNames = new HashSet<String>();
        for (String factType : factTypes) {
            fullyQualifiedClassNames.add(this.convertToFullyQualifiedClassName(factType));
        }
        return fullyQualifiedClassNames;
    }

    private String convertToFullyQualifiedClassName(String factType) {
        if (factType.contains(".")) {
            return factType;
        }
        String fullyQualifiedClassName = null;
        for (Import imp : this.imports.getImports()) {
            if (!imp.getType().endsWith(factType)) continue;
            fullyQualifiedClassName = imp.getType();
            break;
        }
        if (fullyQualifiedClassName == null) {
            fullyQualifiedClassName = this.packageName + "." + factType;
        }
        return fullyQualifiedClassName;
    }

    private Set<String> getConditionFactTypesFromRuleModel(List<IPattern> definition) {
        RuleModel rm = new RuleModel();
        rm.setPackageName(this.model.getPackageName());
        rm.setImports(this.model.getImports());
        for (IPattern p : definition) {
            rm.addLhsItem(p);
        }
        GuidedRuleModelVisitor visitor = new GuidedRuleModelVisitor(rm);
        return visitor.getConsumedModelClasses();
    }

    private Set<String> getActionFactTypesFromRuleModel(List<IAction> definition) {
        RuleModel rm = new RuleModel();
        rm.setPackageName(this.model.getPackageName());
        rm.setImports(this.model.getImports());
        for (IAction a : definition) {
            rm.addRhsItem(a);
        }
        GuidedRuleModelVisitor visitor = new GuidedRuleModelVisitor(rm);
        return visitor.getConsumedModelClasses();
    }
}

