/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDTGraphXMLPersistence;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDecisionTableEditorGraphDeleteHelper;
import org.drools.workbench.screens.guided.dtable.backend.server.MockDirectoryStream;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableGraphEditorService;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableGraphResourceTypeDefinition;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedDecisionTableEditorGraphDeleteHelperTest {
    @Mock
    private IOService ioService;
    @Mock
    private GuidedDecisionTableGraphEditorService dtableGraphService;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    @Mock
    private FileSystem fileSystem;
    @Mock
    private FileSystemProvider fileSystemProvider;
    @Mock
    private BasicFileAttributes basicFileAttributes;
    @Mock
    private org.uberfire.backend.vfs.Path path;
    private List<Path> paths = new ArrayList<Path>();
    private GuidedDTableResourceTypeDefinition dtableType = new GuidedDTableResourceTypeDefinition();
    private GuidedDTableGraphResourceTypeDefinition dtableGraphType = new GuidedDTableGraphResourceTypeDefinition();
    private GuidedDecisionTableEditorGraphDeleteHelper helper;

    @Before
    public void setup() {
        this.paths.clear();
        GuidedDecisionTableEditorGraphDeleteHelper wrapped = new GuidedDecisionTableEditorGraphDeleteHelper(this.ioService, this.dtableType, this.dtableGraphType, this.dtableGraphService, this.commentedOptionFactory);
        this.helper = (GuidedDecisionTableEditorGraphDeleteHelper)Mockito.spy((Object)wrapped);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(Path.class), (DirectoryStream.Filter)Mockito.any(DirectoryStream.Filter.class))).thenAnswer(invocation -> {
            ArrayList<Path> allPaths = new ArrayList<Path>(this.paths);
            DirectoryStream.Filter filter = (DirectoryStream.Filter)invocation.getArguments()[1];
            return new MockDirectoryStream(allPaths.stream().filter(arg_0 -> ((DirectoryStream.Filter)filter).accept(arg_0)).collect(Collectors.toList()));
        });
        Mockito.when((Object)this.fileSystem.provider()).thenReturn((Object)this.fileSystemProvider);
        Mockito.when((Object)this.fileSystemProvider.readAttributes((Path)Mockito.any(Path.class), (Class)Mockito.any(Class.class), new LinkOption[0])).thenReturn((Object)this.basicFileAttributes);
        Mockito.when((Object)this.basicFileAttributes.isRegularFile()).thenReturn((Object)true);
    }

    @Test
    public void checkDoesSupportGuidedDecisionTables() {
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)("a-file." + this.dtableType.getSuffix()));
        Assert.assertTrue((boolean)this.helper.supports(this.path));
    }

    @Test
    public void checkDoesNotSupportNonGuidedDecisionTables() {
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)"a-file.txt");
        Assert.assertFalse((boolean)this.helper.supports(this.path));
    }

    @Test
    public void checkRemoveReferencesNoFiles() {
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)"dtable.gdst");
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"default://test/dtable.gdst");
        this.helper.postProcess(this.path);
        ((GuidedDecisionTableEditorGraphDeleteHelper)Mockito.verify((Object)this.helper, (VerificationMode)Mockito.never())).updateGraphReferences((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class));
    }

    @Test
    public void checkRemoveReferencesWithDecisionTableGraphs() throws URISyntaxException {
        Path dtGraphPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn(Mockito.mock(Path.class));
        Mockito.when((Object)dtGraphPath.toUri()).thenReturn((Object)new URI("default://test/dtable-set." + this.dtableGraphType.getSuffix()));
        Mockito.when((Object)dtGraphPath.getFileSystem()).thenReturn((Object)this.fileSystem);
        this.paths.add(dtGraphPath);
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)"dtable.gdst");
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"default://test/dtable.gdst");
        GuidedDecisionTableEditorGraphModel model = new GuidedDecisionTableEditorGraphModel();
        model.getEntries().add(new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry(this.path, this.path));
        Mockito.when((Object)this.dtableGraphService.load((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)model);
        this.helper.postProcess(this.path);
        ((GuidedDecisionTableEditorGraphDeleteHelper)Mockito.verify((Object)this.helper, (VerificationMode)Mockito.times((int)1))).updateGraphReferences((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class));
        ArgumentCaptor dtGraphPathCaptor = ArgumentCaptor.forClass(Path.class);
        ArgumentCaptor modelXmlCaptor = ArgumentCaptor.forClass(String.class);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)dtGraphPathCaptor.capture(), (String)modelXmlCaptor.capture(), new OpenOption[]{(OpenOption)Mockito.any(CommentedOption.class)});
        Path dtGraphPath2 = (Path)dtGraphPathCaptor.getValue();
        Assert.assertEquals((Object)dtGraphPath.toUri().getPath(), (Object)dtGraphPath2.toUri().getPath());
        String modelXml = (String)modelXmlCaptor.getValue();
        GuidedDecisionTableEditorGraphModel newModel = GuidedDTGraphXMLPersistence.getInstance().unmarshal(modelXml);
        Assert.assertEquals((long)0L, (long)newModel.getEntries().size());
    }

    @Test
    public void checkRemoveReferencesWithoutDecisionTableGraphs() throws URISyntaxException {
        Path dtPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)dtPath.getFileName()).thenReturn(Mockito.mock(Path.class));
        Mockito.when((Object)dtPath.toUri()).thenReturn((Object)new URI("default://test/dtable." + this.dtableType.getSuffix()));
        Mockito.when((Object)dtPath.getFileSystem()).thenReturn((Object)this.fileSystem);
        this.paths.add(dtPath);
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)"dtable.gdst");
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"default://test/dtable.gdst");
        this.helper.postProcess(this.path);
        ((GuidedDecisionTableEditorGraphDeleteHelper)Mockito.verify((Object)this.helper, (VerificationMode)Mockito.never())).updateGraphReferences((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class));
    }
}

