/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuidedDTGraphXMLPersistence {
    private static final Logger logger = LoggerFactory.getLogger(GuidedDTGraphXMLPersistence.class);
    private static final GuidedDTGraphXMLPersistence INSTANCE = new GuidedDTGraphXMLPersistence();
    private XStream xt = new XStream((HierarchicalStreamDriver)new DomDriver());

    private GuidedDTGraphXMLPersistence() {
        this.xt.alias("graph", GuidedDecisionTableEditorGraphModel.class);
        this.xt.alias("entry", GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry.class);
    }

    public static GuidedDTGraphXMLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(GuidedDecisionTableEditorGraphModel content) {
        if (content == null) {
            return this.xt.toXML((Object)new GuidedDecisionTableEditorGraphModel());
        }
        try {
            return this.xt.toXML((Object)content);
        }
        catch (Exception e) {
            logger.error("Unable to marshal model. Returning a XML for empty GuidedDecisionTableEditorGraphModel.", (Throwable)e);
            return this.xt.toXML((Object)new GuidedDecisionTableEditorGraphModel());
        }
    }

    public GuidedDecisionTableEditorGraphModel unmarshal(String xml) {
        if (xml == null || xml.trim().equals("")) {
            return new GuidedDecisionTableEditorGraphModel();
        }
        try {
            Object o = this.xt.fromXML(xml);
            return (GuidedDecisionTableEditorGraphModel)o;
        }
        catch (Exception e) {
            logger.error("Unable to unmarshal content. Returning an empty GuidedDecisionTableEditorGraphModel.", (Throwable)e);
            return new GuidedDecisionTableEditorGraphModel();
        }
    }
}

