/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.indexing;

import java.util.Set;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.ConnectiveConstraint;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.kie.workbench.common.services.refactoring.backend.server.impact.ResourceReferenceCollector;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.model.index.ResourceReference;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.PortablePreconditions;

public class GuidedRuleModelIndexVisitor
extends ResourceReferenceCollector {
    private final DefaultIndexBuilder builder;
    private final RuleModel model;

    public GuidedRuleModelIndexVisitor(DefaultIndexBuilder builder, RuleModel model) {
        this.builder = (DefaultIndexBuilder)PortablePreconditions.checkNotNull((String)"builder", (Object)builder);
        this.model = (RuleModel)PortablePreconditions.checkNotNull((String)"model", (Object)model);
    }

    public Set<Pair<String, String>> visit() {
        this.visit(this.model);
        return this.builder.build();
    }

    private void visit(Object o) {
        if (o instanceof RuleModel) {
            this.visitRuleModel((RuleModel)o);
        } else if (o instanceof RuleAttribute) {
            this.visitRuleAttribute((RuleAttribute)o);
        } else if (o instanceof FactPattern) {
            this.visitFactPattern((FactPattern)o);
        } else if (o instanceof CompositeFieldConstraint) {
            this.visitCompositeFieldConstraint((CompositeFieldConstraint)o);
        } else if (o instanceof SingleFieldConstraintEBLeftSide) {
            this.visitSingleFieldConstraint((SingleFieldConstraintEBLeftSide)o);
        } else if (o instanceof SingleFieldConstraint) {
            this.visitSingleFieldConstraint((SingleFieldConstraint)o);
        } else if (o instanceof ConnectiveConstraint) {
            this.visitConnectiveConstraint((ConnectiveConstraint)o);
        } else if (o instanceof CompositeFactPattern) {
            this.visitCompositeFactPattern((CompositeFactPattern)o);
        } else if (o instanceof FreeFormLine) {
            this.visitFreeFormLine((FreeFormLine)o);
        } else if (o instanceof FromAccumulateCompositeFactPattern) {
            this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)o);
        } else if (o instanceof FromCollectCompositeFactPattern) {
            this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)o);
        } else if (o instanceof FromCompositeFactPattern) {
            this.visitFromCompositeFactPattern((FromCompositeFactPattern)o);
        } else if (o instanceof DSLSentence) {
            this.visitDSLSentence((DSLSentence)o);
        } else if (o instanceof ActionInsertFact) {
            this.visitActionFieldList((ActionInsertFact)o);
        }
    }

    private void visitRuleAttribute(RuleAttribute attr) {
        PartType type = PartType.getPartTypeFromAttribueDescrName((String)attr.getAttributeName());
        this.addSharedReference(attr.getValue(), type);
    }

    private void visitActionFieldList(ActionInsertFact afl) {
        String fqClassName = this.getFullyQualifiedClassName(afl.getFactType());
        this.addResourceReference(fqClassName, ResourceType.JAVA);
    }

    private void visitActionFieldList(String fullyQualifiedClassName, ActionSetField afl) {
        for (ActionFieldValue afv : afl.getFieldValues()) {
            this.visit(fullyQualifiedClassName, afv);
        }
    }

    private void visitCompositeFactPattern(CompositeFactPattern pattern) {
        this.addResourceReference(this.getFullyQualifiedClassName(pattern.getType()), ResourceType.JAVA);
        if (pattern.getPatterns() != null) {
            for (IFactPattern fp : pattern.getPatterns()) {
                this.visit(fp);
            }
        }
    }

    private void visitCompositeFieldConstraint(CompositeFieldConstraint cfc) {
        if (cfc.getConstraints() != null) {
            for (int i = 0; i < cfc.getConstraints().length; ++i) {
                FieldConstraint fc = cfc.getConstraints()[i];
                this.visit(fc);
            }
        }
    }

    private void visitDSLSentence(DSLSentence sentence) {
    }

    private void visitFactPattern(FactPattern pattern) {
        this.addResourceReference(this.getFullyQualifiedClassName(pattern.getFactType()), ResourceType.JAVA);
        for (FieldConstraint fc : pattern.getFieldConstraints()) {
            this.visit(fc);
        }
    }

    private void visitFreeFormLine(FreeFormLine ffl) {
    }

    private void visitFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern pattern) {
        this.visit(pattern.getFactPattern());
        this.visit(pattern.getExpression());
        this.visit(pattern.getSourcePattern());
    }

    private void visitFromCollectCompositeFactPattern(FromCollectCompositeFactPattern pattern) {
        this.visit(pattern.getExpression());
        this.visit(pattern.getFactPattern());
        this.visit(pattern.getRightPattern());
    }

    private void visitFromCompositeFactPattern(FromCompositeFactPattern pattern) {
        this.visit(pattern.getExpression());
        this.visit(pattern.getFactPattern());
    }

    public void visitRuleModel(RuleModel model) {
        int i;
        if (model.attributes != null) {
            for (i = 0; i < model.attributes.length; ++i) {
                RuleAttribute attr = model.attributes[i];
                this.visit(attr);
            }
        }
        if (model.lhs != null) {
            for (i = 0; i < model.lhs.length; ++i) {
                IPattern pattern = model.lhs[i];
                this.visit(pattern);
            }
        }
        if (model.rhs != null) {
            for (i = 0; i < model.rhs.length; ++i) {
                IAction action = model.rhs[i];
                if (action instanceof ActionSetField) {
                    ActionSetField asf = (ActionSetField)action;
                    String typeName = this.getTypeNameForBinding(asf.getVariable());
                    if (typeName == null) continue;
                    String fullyQualifiedClassName = this.getFullyQualifiedClassName(typeName);
                    this.visitActionFieldList(fullyQualifiedClassName, asf);
                    continue;
                }
                this.visit(action);
            }
        }
    }

    private String getTypeNameForBinding(String binding) {
        if (this.model.getAllLHSVariables().contains(binding)) {
            return this.model.getLHSBindingType(binding);
        }
        if (this.model.getAllRHSVariables().contains(binding)) {
            return this.model.getRHSBoundFact(binding).getFactType();
        }
        return null;
    }

    private void visitSingleFieldConstraint(SingleFieldConstraint sfc) {
        ResourceReference resRef = this.addResourceReference(this.getFullyQualifiedClassName(sfc.getFactType()), ResourceType.JAVA);
        resRef.addPartReference(sfc.getFieldName(), PartType.FIELD);
        String fieldType = sfc.getFieldType();
        if (fieldType != null && !fieldType.isEmpty()) {
            this.addResourceReference(this.getFullyQualifiedClassName(sfc.getFactType()), ResourceType.JAVA);
        }
        if (sfc.getConnectives() != null) {
            for (int i = 0; i < sfc.getConnectives().length; ++i) {
                this.visit(sfc.getConnectives()[i]);
            }
        }
    }

    private void visitConnectiveConstraint(ConnectiveConstraint cc) {
        String fqClassName = this.getFullyQualifiedClassName(cc.getFactType());
        ResourceReference resRef = this.addResourceReference(fqClassName, ResourceType.JAVA);
        resRef.addPartReference(cc.getFieldName(), PartType.FIELD);
        this.addResourceReference(this.getFullyQualifiedClassName(cc.getFieldType()), ResourceType.JAVA);
    }

    private void visitSingleFieldConstraint(SingleFieldConstraintEBLeftSide sfexp) {
        this.visit(sfexp.getExpressionLeftSide());
        this.visit(sfexp.getExpressionValue());
        if (sfexp.getConnectives() != null) {
            for (int i = 0; i < sfexp.getConnectives().length; ++i) {
                this.visit(sfexp.getConnectives()[i]);
            }
        }
    }

    private void visit(String fullyQualifiedClassName, ActionFieldValue afv) {
        ResourceReference resRef = this.addResourceReference(fullyQualifiedClassName, ResourceType.JAVA);
        resRef.addPartReference(afv.getField(), PartType.FIELD);
        this.addResourceReference(this.getFullyQualifiedClassName(afv.getType()), ResourceType.JAVA);
    }

    private String getFullyQualifiedClassName(String typeName) {
        if (typeName.contains(".")) {
            return typeName;
        }
        for (Import i : this.model.getImports().getImports()) {
            if (!i.getType().endsWith(typeName)) continue;
            return i.getType();
        }
        String packageName = this.model.getPackageName();
        return packageName != null && !packageName.isEmpty() ? packageName + "." + typeName : typeName;
    }
}

