/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDTGraphXMLPersistence;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;

public class GuidedDTGraphXMLPersistenceTest {
    private static final String emptyModelXml = "<graph><entries/></graph>";

    @Test
    public void checkInstanceIdentity() {
        GuidedDTGraphXMLPersistence s1 = GuidedDTGraphXMLPersistence.getInstance();
        GuidedDTGraphXMLPersistence s2 = GuidedDTGraphXMLPersistence.getInstance();
        Assert.assertEquals((Object)s1, (Object)s2);
    }

    @Test
    public void checkUnmarshallingNull() {
        GuidedDecisionTableEditorGraphModel model = GuidedDTGraphXMLPersistence.getInstance().unmarshal(null);
        this.assertEmptyModel(model);
    }

    @Test
    public void checkUnmarshallingEmptyString() {
        GuidedDecisionTableEditorGraphModel model = GuidedDTGraphXMLPersistence.getInstance().unmarshal("");
        this.assertEmptyModel(model);
    }

    @Test
    public void checkUnmarshallingCorruptString() {
        GuidedDecisionTableEditorGraphModel model = GuidedDTGraphXMLPersistence.getInstance().unmarshal("cheese");
        this.assertEmptyModel(model);
    }

    @Test
    public void checkUnmarshallingEmptyModel() {
        GuidedDecisionTableEditorGraphModel model = GuidedDTGraphXMLPersistence.getInstance().unmarshal(emptyModelXml);
        this.assertEmptyModel(model);
    }

    @Test
    public void checkUnmarshallingModel() {
        GuidedDecisionTableEditorGraphModel model = GuidedDTGraphXMLPersistence.getInstance().unmarshal(emptyModelXml);
        this.assertEmptyModel(model);
    }

    @Test
    public void checkMarshallingNull() {
        String xml = GuidedDTGraphXMLPersistence.getInstance().marshal(null);
        Assert.assertNotNull((Object)xml);
        this.assertEqualsIgnoreWhitespace(emptyModelXml, xml);
    }

    @Test
    public void checkMarshallingModelWithEntryPosition() {
        Path path = PathFactory.newPath((String)"path", (String)"default://path");
        GuidedDecisionTableEditorGraphModel model = new GuidedDecisionTableEditorGraphModel();
        model.getEntries().add(new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry(path, path, Double.valueOf(100.0), Double.valueOf(200.0)));
        String xml = GuidedDTGraphXMLPersistence.getInstance().marshal(model);
        Assert.assertNotNull((Object)xml);
        this.assertEqualsIgnoreWhitespace("<graph>\n  <entries>\n    <entry>\n      <pathHead class=\"org.uberfire.backend.vfs.PathFactory$PathImpl\">\n        <uri>default://path</uri>\n        <fileName>path</fileName>\n        <attributes/>\n        <hasVersionSupport>false</hasVersionSupport>\n      </pathHead>\n      <pathVersion class=\"org.uberfire.backend.vfs.PathFactory$PathImpl\" reference=\"../pathHead\"/>\n      <x>100.0</x>\n      <y>200.0</y>\n    </entry>\n  </entries>\n</graph>", xml);
    }

    @Test
    public void checkMarshallingModelWithoutEntryPosition() {
        Path path = PathFactory.newPath((String)"path", (String)"default://path");
        GuidedDecisionTableEditorGraphModel model = new GuidedDecisionTableEditorGraphModel();
        model.getEntries().add(new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry(path, path));
        String xml = GuidedDTGraphXMLPersistence.getInstance().marshal(model);
        Assert.assertNotNull((Object)xml);
        this.assertEqualsIgnoreWhitespace("<graph>\n  <entries>\n    <entry>\n      <pathHead class=\"org.uberfire.backend.vfs.PathFactory$PathImpl\">\n        <uri>default://path</uri>\n        <fileName>path</fileName>\n        <attributes/>\n        <hasVersionSupport>false</hasVersionSupport>\n      </pathHead>\n      <pathVersion class=\"org.uberfire.backend.vfs.PathFactory$PathImpl\" reference=\"../pathHead\"/>\n    </entry>\n  </entries>\n</graph>", xml);
    }

    private void assertEmptyModel(GuidedDecisionTableEditorGraphModel model) {
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getEntries());
        Assert.assertEquals((long)0L, (long)model.getEntries().size());
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }
}

