/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDecisionTableGraphEditorServiceImpl;
import org.drools.workbench.screens.guided.dtable.backend.server.MockDirectoryStream;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphContent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableLinkManager;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableGraphResourceTypeDefinition;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.drools.workbench.screens.workitems.service.WorkItemsEditorService;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.version.VersionRecordService;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedDecisionTableGraphEditorServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private CopyService copyService;
    @Mock
    private DeleteService deleteService;
    @Mock
    private RenameService renameService;
    @Mock
    private DataModelService dataModelService;
    @Mock
    private WorkItemsEditorService workItemsService;
    @Mock
    private KieProjectService projectService;
    @Mock
    private VersionRecordService versionRecordService;
    @Mock
    private GuidedDecisionTableEditorService dtableService;
    @Mock
    private GuidedDecisionTableLinkManager dtableLinkManager;
    @Mock
    private Event<ResourceOpenedEvent> resourceOpenedEvent = new EventSourceMock();
    @Mock
    private GenericValidator genericValidator;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    @Mock
    private MetadataServerSideService mockMetaDataService;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private Package pkg;
    private GuidedDecisionTableGraphEditorServiceImpl service;
    private GuidedDTableResourceTypeDefinition dtResourceType = new GuidedDTableResourceTypeDefinition();
    private GuidedDTableGraphResourceTypeDefinition dtGraphResourceType = new GuidedDTableGraphResourceTypeDefinition();
    private final List<Path> resolvedPaths = new ArrayList<Path>();

    @Before
    public void setup() {
        this.service = new GuidedDecisionTableGraphEditorServiceImpl(this.ioService, this.copyService, this.deleteService, this.renameService, this.projectService, this.versionRecordService, this.dtableService, this.dtableLinkManager, this.resourceOpenedEvent, this.commentedOptionFactory, this.dtResourceType, this.sessionInfo){
            {
                this.metadataService = GuidedDecisionTableGraphEditorServiceImplTest.this.mockMetaDataService;
            }
        };
        Mockito.when((Object)this.projectService.resolvePackage((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)this.pkg);
        Mockito.when((Object)this.pkg.getPackageMainResourcesPath()).thenReturn((Object)PathFactory.newPath((String)"project", (String)"default://project/src/main/resources"));
        this.resolvedPaths.clear();
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(Path.class))).thenReturn((Object)new MockDirectoryStream(this.resolvedPaths));
    }

    @Test
    public void checkCreate() {
        org.uberfire.backend.vfs.Path context = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String fileName = "filename." + this.dtGraphResourceType.getSuffix();
        GuidedDecisionTableEditorGraphModel content = new GuidedDecisionTableEditorGraphModel();
        String comment = "comment";
        Mockito.when((Object)context.toURI()).thenReturn((Object)"default://project/src/main/resources/mypackage");
        org.uberfire.backend.vfs.Path p = this.service.create(context, fileName, content, "comment");
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.any(Path.class), (String)Mockito.any(String.class), new OpenOption[]{(OpenOption)Mockito.any(CommentedOption.class)});
        Assert.assertTrue((boolean)p.toURI().contains("src/main/resources/mypackage/filename." + this.dtGraphResourceType.getSuffix()));
    }

    @Test
    public void checkLoad() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)("default://project/src/main/resources/mypackage/dtable." + this.dtGraphResourceType.getSuffix()));
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)"");
        GuidedDecisionTableEditorGraphModel model = this.service.load(path);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).readAllString((Path)Mockito.any(Path.class));
        Assert.assertNotNull((Object)model);
    }

    @Test
    public void checkConstructContent() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)("default://project/src/main/resources/mypackage/dtable." + this.dtGraphResourceType.getSuffix()));
        GuidedDecisionTableEditorGraphContent content = this.service.constructContent(path, overview);
        ((Event)Mockito.verify(this.resourceOpenedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(ResourceOpenedEvent.class));
        Assert.assertNotNull((Object)content.getModel());
        Assert.assertEquals((Object)overview, (Object)content.getOverview());
    }

    @Test
    public void checkSave() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        GuidedDecisionTableEditorGraphModel model = new GuidedDecisionTableEditorGraphModel();
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        String comment = "comment";
        Mockito.when((Object)path.toURI()).thenReturn((Object)("default://project/src/main/resources/mypackage/dtable." + this.dtGraphResourceType.getSuffix()));
        this.service.save(path, model, metadata, "comment");
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.any(Path.class), (String)Mockito.any(String.class), (Map)Mockito.any(Map.class), new OpenOption[]{(OpenOption)Mockito.any(CommentedOption.class)});
    }

    @Test
    public void checkDelete() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String comment = "comment";
        this.service.delete(path, "comment");
        ((DeleteService)Mockito.verify((Object)this.deleteService, (VerificationMode)Mockito.times((int)1))).delete((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Mockito.eq((Object)"comment"));
    }

    @Test
    public void checkRename() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String newFileName = "newFileName";
        String comment = "comment";
        this.service.rename(path, "newFileName", "comment");
        ((RenameService)Mockito.verify((Object)this.renameService, (VerificationMode)Mockito.times((int)1))).rename((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Mockito.eq((Object)"newFileName"), (String)Mockito.eq((Object)"comment"));
    }

    @Test
    public void checkCopy() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String newFileName = "newFileName";
        String comment = "comment";
        this.service.copy(path, "newFileName", "comment");
        ((CopyService)Mockito.verify((Object)this.copyService, (VerificationMode)Mockito.times((int)1))).copy((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Mockito.eq((Object)"newFileName"), (String)Mockito.eq((Object)"comment"));
    }

    @Test
    public void copyCopyToPackage() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String newFileName = "newFileName";
        org.uberfire.backend.vfs.Path newPackagePath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String comment = "comment";
        this.service.copy(path, "newFileName", newPackagePath, "comment");
        ((CopyService)Mockito.verify((Object)this.copyService, (VerificationMode)Mockito.times((int)1))).copy((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Mockito.eq((Object)"newFileName"), (org.uberfire.backend.vfs.Path)Mockito.eq((Object)newPackagePath), (String)Mockito.eq((Object)"comment"));
    }

    @Test
    public void testListDecisionTablesInPackage() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://project/src/main/resources/dtable1.gdst");
        this.resolvedPaths.add(this.makeNioPath("default://project/src/main/resources/dtable1.gdst"));
        this.resolvedPaths.add(this.makeNioPath("default://project/src/main/resources/dtable2.gdst"));
        this.resolvedPaths.add(this.makeNioPath("default://project/src/main/resources/dtable3.gdst"));
        this.resolvedPaths.add(this.makeNioPath("default://project/src/main/resources/pupa.smurf"));
        List paths = this.service.listDecisionTablesInPackage(path);
        Assert.assertNotNull((Object)paths);
        Assert.assertEquals((long)3L, (long)paths.size());
        HashSet fileNames = new HashSet();
        fileNames.addAll(paths.stream().collect(Collectors.mapping(org.uberfire.backend.vfs.Path::getFileName, Collectors.toSet())));
        Assert.assertTrue((boolean)fileNames.contains("dtable1.gdst"));
        Assert.assertTrue((boolean)fileNames.contains("dtable2.gdst"));
        Assert.assertTrue((boolean)fileNames.contains("dtable3.gdst"));
    }

    private Path makeNioPath(String uri) {
        return Paths.get((String)uri, (String[])new String[0]);
    }
}

