/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.indexing;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDTGraphXMLPersistence;
import org.drools.workbench.screens.guided.dtable.backend.server.indexing.TestGuidedDecisionTableGraphFileIndexer;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableGraphResourceTypeDefinition;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexGuidedDecisionTableGraphFileTest
extends BaseIndexingTest<GuidedDTableGraphResourceTypeDefinition> {
    @Test
    public void testIndexGuidedDecisionTableGraphEntries() throws IOException, InterruptedException {
        Path path = this.basePath.resolve("dtable-graph1.gdst-set");
        Path dtable1Path = this.basePath.resolve("dtable1.gdst");
        Path dtable2Path = this.basePath.resolve("dtable2.gdst");
        org.uberfire.backend.vfs.Path vfsDtable1Path = Paths.convert((Path)dtable1Path);
        org.uberfire.backend.vfs.Path vfsDtable2Path = Paths.convert((Path)dtable2Path);
        GuidedDecisionTableEditorGraphModel model = new GuidedDecisionTableEditorGraphModel();
        model.getEntries().add(new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry(vfsDtable1Path, vfsDtable1Path));
        model.getEntries().add(new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry(vfsDtable2Path, vfsDtable2Path));
        String xml = GuidedDTGraphXMLPersistence.getInstance().marshal(model);
        this.ioService().write(path, xml, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexGuidedDecisionTableGraphFileTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        Query query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueSharedPartIndexTerm(vfsDtable1Path.toURI(), PartType.PATH)).build();
        this.searchFor(index, query, 1, new Path[]{path});
        query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueSharedPartIndexTerm(vfsDtable2Path.toURI(), PartType.PATH)).build();
        this.searchFor(index, query, 1, new Path[]{path});
    }

    protected TestIndexer<GuidedDTableGraphResourceTypeDefinition> getIndexer() {
        return new TestGuidedDecisionTableGraphFileIndexer();
    }

    protected GuidedDTableGraphResourceTypeDefinition getResourceTypeDefinition() {
        return new GuidedDTableGraphResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

