/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.indexing;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.backend.server.indexing.GuidedRuleModelIndexVisitor;
import org.kie.workbench.common.services.refactoring.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.ResourceReference;
import org.kie.workbench.common.services.refactoring.SharedPart;
import org.kie.workbench.common.services.refactoring.backend.server.impact.ResourceReferenceCollector;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.model.KProperty;

public class GuidedDecisionTableModelIndexVisitor
extends ResourceReferenceCollector {
    private final DefaultIndexBuilder builder;
    private final GuidedDecisionTable52 model;
    private final Set<KProperty<?>> results = new HashSet();

    public GuidedDecisionTableModelIndexVisitor(DefaultIndexBuilder builder, GuidedDecisionTable52 model) {
        this.builder = (DefaultIndexBuilder)PortablePreconditions.checkNotNull((String)"builder", (Object)builder);
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
    }

    public Set<KProperty<?>> visit() {
        this.visit(this.model);
        this.results.addAll(this.builder.build());
        return this.results;
    }

    private void visit(Object o) {
        if (o instanceof GuidedDecisionTable52) {
            this.visit((GuidedDecisionTable52)o);
        } else if (o instanceof AttributeCol52) {
            this.visit((AttributeCol52)o);
        } else if (o instanceof Pattern52) {
            this.visit((Pattern52)o);
        } else if (o instanceof BRLConditionColumn) {
            this.visit((BRLConditionColumn)o);
        } else if (o instanceof ConditionCol52) {
            this.visit((ConditionCol52)o);
        } else if (o instanceof BRLActionColumn) {
            this.visit((BRLActionColumn)o);
        } else if (o instanceof ActionInsertFactCol52) {
            this.visit((ActionInsertFactCol52)o);
        } else if (o instanceof ActionSetFieldCol52) {
            this.visit((ActionSetFieldCol52)o);
        } else if (o instanceof Imports) {
            this.visit((Imports)o);
        }
    }

    private void visit(GuidedDecisionTable52 o) {
        this.visit(o.getImports());
        for (AttributeCol52 c : o.getAttributeCols()) {
            this.visit(c);
        }
        for (AttributeCol52 c : o.getConditions()) {
            this.visit((Object)c);
        }
        for (AttributeCol52 c : o.getActionCols()) {
            this.visit((Object)c);
        }
        String parentRuleName = this.model.getParentName();
        for (List row : this.model.getData()) {
            String ruleName = "Row " + ((DTCellValue52)row.get(0)).getNumericValue().longValue() + " " + this.model.getTableName();
            this.addResourceReference(ruleName, ResourceType.RULE);
            if (parentRuleName == null) continue;
            this.addResourceReference(parentRuleName, ResourceType.RULE);
        }
    }

    private void visit(AttributeCol52 o) {
        int iCol = this.model.getExpandedColumns().indexOf(o);
        for (List row : this.model.getData()) {
            String attributeValue = ((DTCellValue52)row.get(iCol)).getStringValue();
            if (attributeValue == null || attributeValue.isEmpty()) continue;
            String attrName = o.getAttribute();
            PartType type = PartType.getPartTypeFromAttribueDescrName((String)attrName);
            switch (type) {
                case AGENDA_GROUP: 
                case ACTIVATION_GROUP: 
                case RULEFLOW_GROUP: 
                case ENTRY_POINT: {
                    SharedPart sharedRef = new SharedPart(attributeValue, type);
                    this.builder.addGenerator((IndexElementsGenerator)sharedRef);
                    break;
                }
            }
        }
    }

    private void visit(Pattern52 o) {
        String fqClassName = this.getFullyQualifiedClassName(o.getFactType());
        this.addResourceReference(fqClassName, ResourceType.JAVA);
        for (ConditionCol52 c : o.getChildColumns()) {
            this.visit(c);
        }
    }

    private void visit(BRLConditionColumn o) {
        RuleModel rm = new RuleModel();
        rm.setImports(this.model.getImports());
        for (IPattern p : o.getDefinition()) {
            rm.addLhsItem(p);
        }
        GuidedRuleModelIndexVisitor visitor = new GuidedRuleModelIndexVisitor(this.builder, rm);
        this.results.addAll(visitor.visit());
        this.addResourceReferences(visitor);
    }

    private void visit(ConditionCol52 o) {
        Pattern52 p = this.model.getPattern(o);
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(p.getFactType());
        ResourceReference resRef = this.addResourceReference(fullyQualifiedClassName, ResourceType.JAVA);
        resRef.addPartReference(o.getFactField(), PartType.FIELD);
        this.addResourceReference(this.getFullyQualifiedClassName(o.getFieldType()), ResourceType.JAVA);
    }

    private void visit(BRLActionColumn o) {
        RuleModel rm = new RuleModel();
        rm.setImports(this.model.getImports());
        for (IAction a : o.getDefinition()) {
            rm.addRhsItem(a);
        }
        GuidedRuleModelIndexVisitor visitor = new GuidedRuleModelIndexVisitor(this.builder, rm);
        this.results.addAll(visitor.visit());
    }

    private void visit(ActionInsertFactCol52 o) {
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(o.getFactType());
        ResourceReference resRef = this.addResourceReference(fullyQualifiedClassName, ResourceType.JAVA);
        resRef.addPartReference(o.getFactField(), PartType.FIELD);
        this.addResourceReference(this.getFullyQualifiedClassName(o.getType()), ResourceType.JAVA);
    }

    private void visit(ActionSetFieldCol52 o) {
        Pattern52 p = this.model.getConditionPattern(o.getBoundName());
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(p.getFactType());
        ResourceReference resRef = this.addResourceReference(fullyQualifiedClassName, ResourceType.JAVA);
        resRef.addPartReference(o.getFactField(), PartType.FIELD);
        this.addResourceReference(this.getFullyQualifiedClassName(o.getType()), ResourceType.JAVA);
    }

    private void visit(Imports o) {
        for (Import imp : o.getImports()) {
            this.addResourceReference(imp.getType(), ResourceType.JAVA);
        }
    }

    private String getFullyQualifiedClassName(String typeName) {
        if (typeName.contains(".")) {
            return typeName;
        }
        for (Import i : this.model.getImports().getImports()) {
            if (!i.getType().endsWith(typeName)) continue;
            return i.getType();
        }
        String packageName = this.model.getPackageName();
        return packageName != null && !packageName.isEmpty() ? packageName + "." + typeName : typeName;
    }
}

