/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.indexing;

import java.util.Collection;
import java.util.Collections;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.indexing.GuidedDecisionTableFactory;
import org.drools.workbench.screens.guided.dtable.backend.server.indexing.GuidedDecisionTableModelIndexVisitor;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.refactoring.Resource;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedDecisionTableModelIndexVisitorTest {
    @Mock
    private Project project;
    @Mock
    private Package pkg;
    private GuidedDecisionTable52 model;
    private DefaultIndexBuilder builder;
    private GuidedDecisionTableModelIndexVisitor visitor;

    @Before
    public void setup() {
        this.model = GuidedDecisionTableFactory.makeTableWithAttributeCol("packageName", Collections.emptyList(), "tableName");
        this.builder = new DefaultIndexBuilder("fileName", this.project, this.pkg);
        this.visitor = new GuidedDecisionTableModelIndexVisitor(this.builder, this.model);
    }

    @Test
    public void checkRuleNamesAreExtracted() {
        this.visitor.visit();
        Collection resources = this.visitor.getResources();
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Resource resource = (Resource)resources.iterator().next();
        Assert.assertEquals((Object)"packageName.Row 1 tableName", (Object)resource.getResourceFQN());
        Assert.assertEquals((Object)ResourceType.RULE, (Object)resource.getResourceType());
    }
}

