/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDTGraphXMLPersistence;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableGraphEditorService;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableGraphResourceTypeDefinition;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.guvnor.common.services.backend.file.FileExtensionFilter;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.helper.RenameHelper;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class GuidedDecisionTableEditorGraphRenameHelper
implements RenameHelper {
    private IOService ioService;
    private GuidedDTableResourceTypeDefinition dtableType;
    private GuidedDTableGraphResourceTypeDefinition dtableGraphType;
    private GuidedDecisionTableGraphEditorService dtableGraphService;
    private CommentedOptionFactory commentedOptionFactory;

    public GuidedDecisionTableEditorGraphRenameHelper() {
    }

    @Inject
    public GuidedDecisionTableEditorGraphRenameHelper(@Named(value="ioStrategy") IOService ioService, GuidedDTableResourceTypeDefinition dtableType, GuidedDTableGraphResourceTypeDefinition dtableGraphType, GuidedDecisionTableGraphEditorService dtableGraphService, CommentedOptionFactory commentedOptionFactory) {
        this.ioService = ioService;
        this.dtableType = dtableType;
        this.dtableGraphType = dtableGraphType;
        this.dtableGraphService = dtableGraphService;
        this.commentedOptionFactory = commentedOptionFactory;
    }

    public boolean supports(org.uberfire.backend.vfs.Path destination) {
        return this.dtableType.accept(destination);
    }

    public void postProcess(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path destination) {
        try (DirectoryStream directoryStream = this.ioService.newDirectoryStream(this.getParentFolder(source), (DirectoryStream.Filter)new FileExtensionFilter(this.dtableGraphType.getSuffix()));){
            directoryStream.forEach(path -> this.updateGraphElementPath(source, destination, Paths.convert((Path)path)));
        }
    }

    Path getParentFolder(org.uberfire.backend.vfs.Path path) {
        Path nioFolderPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        return Files.isDirectory((Path)nioFolderPath, (LinkOption[])new LinkOption[0]) ? nioFolderPath : nioFolderPath.getParent();
    }

    void updateGraphElementPath(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path destination, org.uberfire.backend.vfs.Path graphPath) {
        GuidedDecisionTableEditorGraphModel dtGraphModel = (GuidedDecisionTableEditorGraphModel)this.dtableGraphService.load(graphPath);
        Set dtGraphEntries = dtGraphModel.getEntries();
        dtGraphEntries.forEach(e -> {
            if (e.getPathHead().equals(source)) {
                e.setPathHead(destination);
                e.setPathVersion(destination);
            }
        });
        this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)graphPath), GuidedDTGraphXMLPersistence.getInstance().marshal(dtGraphModel), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption("File [" + source.toURI() + "] renamed to [" + destination.toURI() + "].")});
    }
}

