/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.kie.soup.commons.validation.PortablePreconditions;

public class PatternRowBuilder {
    private static final int PATTERN_ROW = 6;
    private final GuidedDecisionTable52 dtable;
    private final Sheet sheet;
    private final Row patternRow;
    private int columnIndex = 0;

    public PatternRowBuilder(Sheet sheet, GuidedDecisionTable52 dtable) {
        this.sheet = (Sheet)PortablePreconditions.checkNotNull((String)"sheet", (Object)sheet);
        this.dtable = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"dtable", (Object)dtable);
        this.patternRow = sheet.createRow(6);
    }

    public void build() {
        List expandedColumns = this.dtable.getExpandedColumns();
        for (int sourceIndex = 0; sourceIndex < expandedColumns.size(); ++sourceIndex) {
            BaseColumn baseColumn = (BaseColumn)expandedColumns.get(sourceIndex);
            if (baseColumn instanceof BRLConditionVariableColumn || baseColumn instanceof BRLConditionColumn || baseColumn instanceof BRLActionVariableColumn || baseColumn instanceof BRLActionColumn) {
                throw new UnsupportedOperationException("Conversion of the BRL column is not supported.");
            }
            if (baseColumn instanceof ConditionCol52) {
                ConditionCol52 col = (ConditionCol52)baseColumn;
                Pattern52 pattern = this.dtable.getPattern(col);
                int columnWidth = this.dtable.getConditionPattern(pattern.getBoundName()).getChildColumns().size();
                int endIndex = this.columnIndex + columnWidth - 1;
                for (int i = this.columnIndex; i <= endIndex; ++i) {
                    this.patternRow.createCell(i).setCellValue(String.format("%s : %s", pattern.getBoundName(), pattern.getFactType()));
                }
                if (columnWidth > 1) {
                    this.sheet.addMergedRegion(new CellRangeAddress(6, 6, this.columnIndex, endIndex));
                    this.sheet.validateMergedRegions();
                    this.columnIndex = endIndex;
                    sourceIndex = sourceIndex + columnWidth - 1;
                }
            } else if (baseColumn instanceof RowNumberCol52) continue;
            ++this.columnIndex;
        }
    }
}

