/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.kie.soup.commons.validation.PortablePreconditions;

public class SubHeaderBuilder {
    private static final int COLUMN_TYPE_ROW = 5;
    private static final int FIELD_ROW = 7;
    private static final int HEADER_TITLE_ROW = 8;
    private final GuidedDecisionTable52 dtable;
    private final String ACTION = "ACTION";
    private final String CONDITION = "CONDITION";
    private int columnIndex = 0;
    private Row headerRow;
    private Row fieldRow;
    private Row headerTitleRow;
    private List<String> addedInserts = new ArrayList<String>();

    public SubHeaderBuilder(Sheet sheet, GuidedDecisionTable52 dtable) {
        PortablePreconditions.checkNotNull((String)"sheet", (Object)sheet);
        this.dtable = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"dtable", (Object)dtable);
        this.headerRow = sheet.createRow(5);
        this.fieldRow = sheet.createRow(7);
        this.headerTitleRow = sheet.createRow(8);
    }

    public void build() {
        List expandedColumns = this.dtable.getExpandedColumns();
        for (int sourceIndex = 0; sourceIndex < expandedColumns.size(); ++sourceIndex) {
            BaseColumn baseColumn = (BaseColumn)expandedColumns.get(sourceIndex);
            if (baseColumn instanceof AttributeCol52) {
                this.makeAttribute((AttributeCol52)baseColumn);
            } else if (!(baseColumn instanceof MetadataCol52)) {
                if (baseColumn instanceof ConditionCol52) {
                    this.makeCondition((ConditionCol52)baseColumn);
                } else if (baseColumn instanceof ActionCol52) {
                    this.makeAction(baseColumn);
                } else {
                    if (baseColumn instanceof RowNumberCol52) continue;
                    if (!(baseColumn instanceof DescriptionCol52)) {
                        throw new IllegalArgumentException("TODO REMOTE THIS");
                    }
                }
            }
            ++this.columnIndex;
        }
    }

    private void makeAction(BaseColumn baseColumn) {
        if (baseColumn instanceof ActionSetFieldCol52) {
            this.makeSetField((ActionSetFieldCol52)baseColumn);
        } else if (baseColumn instanceof ActionInsertFactCol52) {
            this.makeInsert((ActionInsertFactCol52)baseColumn);
        } else if (baseColumn instanceof ActionRetractFactCol52) {
            this.makeRetract((ActionRetractFactCol52)baseColumn);
        }
    }

    private void makeHeaderAndTitle(String action, String header) {
        this.headerRow.createCell(this.columnIndex).setCellValue(action);
        this.headerTitleRow.createCell(this.columnIndex).setCellValue(header);
    }

    private void makeRetract(ActionRetractFactCol52 column) {
        this.makeHeaderAndTitle("ACTION", column.getHeader());
        this.fieldRow.createCell(this.columnIndex).setCellValue("retract( $param );");
    }

    private void makeInsert(ActionInsertFactCol52 column) {
        if (!this.addedInserts.contains(column.getBoundName())) {
            this.makeHeaderAndTitle("ACTION", "");
            this.fieldRow.createCell(this.columnIndex).setCellValue(column.getFactType() + " " + column.getBoundName() + " = new " + column.getFactType() + "(); insert( " + column.getBoundName() + " );");
            this.addedInserts.add(column.getBoundName());
            ++this.columnIndex;
        }
        this.makeHeaderAndTitle("ACTION", column.getHeader());
        this.fieldRow.createCell(this.columnIndex).setCellValue(this.makeSetMethod(column.getBoundName(), column.getFactField()));
    }

    private void makeSetField(ActionSetFieldCol52 column) {
        this.makeHeaderAndTitle("ACTION", column.getHeader());
        this.fieldRow.createCell(this.columnIndex).setCellValue(this.makeSetMethod(column.getBoundName(), column.getFactField()));
    }

    private void makeCondition(ConditionCol52 column) {
        this.makeHeaderAndTitle("CONDITION", column.getHeader());
        this.fieldRow.createCell(this.columnIndex).setCellValue(String.format("%s %s $param", column.getFactField(), column.getOperator()));
    }

    private void makeAttribute(AttributeCol52 column) {
        if (Objects.equals("negate", column.getAttribute().toLowerCase())) {
            throw new UnsupportedOperationException("Conversion of the negate attribute is not supported.");
        }
        this.headerRow.createCell(this.columnIndex).setCellValue(this.getAttribute(column));
    }

    private String getAttribute(AttributeCol52 column) {
        if (Objects.equals("salience", column.getAttribute())) {
            return "PRIORITY";
        }
        return column.getAttribute().toUpperCase();
    }

    private String makeSetMethod(String boundName, String factField) {
        return String.format("%s.set%s%s( $param );", boundName, factField.substring(0, 1).toUpperCase(), factField.substring(1));
    }
}

