/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.lang.Expander;
import org.drools.compiler.lang.dsl.DSLMappingFile;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.compiler.lang.dsl.DefaultExpander;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTDRLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.kie.workbench.common.services.backend.file.DSLFileFilter;
import org.kie.workbench.common.services.backend.source.BaseSourceService;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.source.SourceGenerationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class GuidedDecisionTableSourceService
extends BaseSourceService<GuidedDecisionTable52> {
    private static final Logger logger = LoggerFactory.getLogger(GuidedDecisionTableSourceService.class);
    private static final DSLFileFilter FILTER_DSLS = new DSLFileFilter();
    private GuidedDTableResourceTypeDefinition resourceType;
    private GuidedDecisionTableEditorService guidedDecisionTableEditorService;
    private IOService ioService;
    private FileDiscoveryService fileDiscoveryService;
    private KieProjectService projectService;
    private Collection<RuleModelIActionPersistenceExtension> persistenceExtensions = new ArrayList<RuleModelIActionPersistenceExtension>();

    @Inject
    public GuidedDecisionTableSourceService(GuidedDTableResourceTypeDefinition resourceType, GuidedDecisionTableEditorService guidedDecisionTableEditorService, @Named(value="ioStrategy") IOService ioService, FileDiscoveryService fileDiscoveryService, KieProjectService projectService, Instance<RuleModelIActionPersistenceExtension> persistenceExtensionInstance) {
        this.resourceType = resourceType;
        this.guidedDecisionTableEditorService = guidedDecisionTableEditorService;
        this.ioService = ioService;
        this.fileDiscoveryService = fileDiscoveryService;
        this.projectService = projectService;
        persistenceExtensionInstance.iterator().forEachRemaining(this.persistenceExtensions::add);
    }

    public String getPattern() {
        return this.resourceType.getSuffix();
    }

    public String getSource(Path path, GuidedDecisionTable52 model) throws SourceGenerationFailedException {
        try {
            String dslr = GuidedDTDRLPersistence.getInstance().marshal(model, this.persistenceExtensions);
            Expander expander = this.getDSLExpander(path);
            String drl = expander.expand(dslr);
            return drl;
        }
        catch (Exception e) {
            throw new SourceGenerationFailedException(e.getMessage());
        }
    }

    public String getSource(Path path) throws SourceGenerationFailedException {
        return this.getSource(path, (GuidedDecisionTable52)this.guidedDecisionTableEditorService.load(Paths.convert((Path)path)));
    }

    private Expander getDSLExpander(Path path) {
        DefaultExpander expander = new DefaultExpander();
        List<DSLMappingFile> dsls = this.getDSLMappingFiles(path);
        for (DSLMappingFile dsl : dsls) {
            expander.addDSLMapping(dsl.getMapping());
        }
        return expander;
    }

    private List<DSLMappingFile> getDSLMappingFiles(Path path) {
        ArrayList<DSLMappingFile> dsls = new ArrayList<DSLMappingFile>();
        org.uberfire.backend.vfs.Path vfsPath = Paths.convert((Path)path);
        org.uberfire.backend.vfs.Path packagePath = this.projectService.resolvePackage(vfsPath).getPackageMainResourcesPath();
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)packagePath);
        Collection dslPaths = this.fileDiscoveryService.discoverFiles(nioPackagePath, (DirectoryStream.Filter)FILTER_DSLS);
        for (Path dslPath : dslPaths) {
            String dslDefinition = this.ioService.readAllString(dslPath);
            DSLTokenizedMappingFile dslFile = new DSLTokenizedMappingFile();
            try {
                if (dslFile.parseAndLoad((Reader)new StringReader(dslDefinition))) {
                    dsls.add((DSLMappingFile)dslFile);
                    continue;
                }
                logger.error("Unable to parse DSL definition: " + dslDefinition);
            }
            catch (IOException ioe) {
                logger.error(ioe.getMessage());
            }
        }
        return dsls;
    }
}

