/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.DataBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.PatternRowBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.SubHeaderBuilder;
import org.drools.workbench.screens.guided.dtable.shared.XLSConversionResult;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;

public class XLSBuilder {
    private static final int RULE_SET_ROW = 1;
    private static final int IMPORTS_ROW = 2;
    private static final int RULE_TABLE_ROW = 4;
    private final GuidedDecisionTable52 dtable;
    private final Sheet sheet;
    private final Workbook workbook;
    private final PackageDataModelOracle dmo;

    public XLSBuilder(GuidedDecisionTable52 dtable, PackageDataModelOracle dmo) {
        this.dtable = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"dtable", (Object)dtable);
        this.dmo = (PackageDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.workbook = new HSSFWorkbook();
        this.sheet = this.workbook.createSheet("Hello");
    }

    public BuildResult build() {
        try {
            this.makeRuleSet();
            this.makeImports();
            this.makeTable();
        }
        catch (UnsupportedOperationException e) {
            return new BuildResult(this.workbook, new XLSConversionResult(e.getMessage()));
        }
        catch (Exception e) {
            return new BuildResult(this.workbook, new XLSConversionResult(e.toString() + " : " + e.getMessage()));
        }
        return new BuildResult(this.workbook, new XLSConversionResult());
    }

    private void makeRuleSet() {
        Row headerRow = this.sheet.createRow(1);
        Cell ruleSetCellLabel = headerRow.createCell(1);
        ruleSetCellLabel.setCellValue("RuleSet");
        Cell ruleSetCell = headerRow.createCell(2);
        ruleSetCell.setCellValue(this.dtable.getPackageName());
    }

    private void makeImports() {
        Row headerRow = this.sheet.createRow(2);
        headerRow.createCell(1).setCellValue("Import");
        headerRow.createCell(2).setCellValue(this.dtable.getImports().getImports().stream().map(anImport -> anImport.getType()).collect(Collectors.joining(", ")));
    }

    private void makeTable() {
        this.makeTableHeader();
        this.makeTableSubHeader();
        this.makePatternRow();
        this.makeDTableColumns();
    }

    private void makeTableHeader() {
        Row headerRow = this.sheet.createRow(4);
        Cell cell = headerRow.createCell(1);
        cell.setCellValue("RuleTable " + this.dtable.getTableName());
    }

    private void makeTableSubHeader() {
        new SubHeaderBuilder(this.sheet, this.dtable, this.dmo).build();
    }

    private void makePatternRow() {
        new PatternRowBuilder(this.sheet, this.dtable).build();
    }

    private void makeDTableColumns() {
        new DataBuilder(this.sheet, this.dtable, this.dmo).build();
    }

    class BuildResult {
        private final Workbook workbook;
        private final XLSConversionResult conversionResult;

        BuildResult(Workbook workbook, XLSConversionResult conversionResult) {
            this.workbook = workbook;
            this.conversionResult = conversionResult;
        }

        public Workbook getWorkbook() {
            return this.workbook;
        }

        public XLSConversionResult getConversionResult() {
            return this.conversionResult;
        }
    }
}

