/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import javax.enterprise.event.Event;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDecisionTableEditorServiceImpl;
import org.drools.workbench.screens.guided.dtable.backend.server.MockDirectoryStream;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableGraphEditorService;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableGraphResourceTypeDefinition;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.drools.workbench.screens.workitems.service.WorkItemsEditorService;
import org.guvnor.common.services.backend.file.FileExtensionFilter;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.backend.source.SourceService;
import org.kie.workbench.common.services.backend.source.SourceServices;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.version.VersionRecordService;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.version.impl.PortableVersionRecord;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedDecisionTableEditorServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private CopyService copyService;
    @Mock
    private DeleteService deleteService;
    @Mock
    private RenameService renameService;
    @Mock
    private DataModelService dataModelService;
    @Mock
    private WorkItemsEditorService workItemsService;
    @Mock
    private KieProjectService projectService;
    @Mock
    private VersionRecordService versionRecordService;
    @Mock
    private GuidedDecisionTableGraphEditorService dtableGraphService;
    @Mock
    private Event<ResourceOpenedEvent> resourceOpenedEvent = new EventSourceMock();
    @Mock
    private GenericValidator genericValidator;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    @Mock
    private SourceServices mockSourceServices;
    @Mock
    private MetadataServerSideService mockMetaDataService;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private Package pkg;
    @Mock
    private FileSystem fileSystem;
    @Mock
    private FileSystemProvider fileSystemProvider;
    @Mock
    private BasicFileAttributes basicFileAttributes;
    private GuidedDTableResourceTypeDefinition dtType = new GuidedDTableResourceTypeDefinition();
    private GuidedDTableGraphResourceTypeDefinition dtGraphType = new GuidedDTableGraphResourceTypeDefinition();
    private GuidedDecisionTableEditorServiceImpl service;

    @Before
    public void setup() {
        this.service = new GuidedDecisionTableEditorServiceImpl(this.ioService, this.copyService, this.deleteService, this.renameService, this.dataModelService, this.workItemsService, this.projectService, this.versionRecordService, this.dtableGraphService, this.dtGraphType, this.resourceOpenedEvent, this.genericValidator, this.commentedOptionFactory, this.sessionInfo){
            {
                this.sourceServices = GuidedDecisionTableEditorServiceImplTest.this.mockSourceServices;
                this.metadataService = GuidedDecisionTableEditorServiceImplTest.this.mockMetaDataService;
            }
        };
        Mockito.when((Object)this.projectService.resolvePackage((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)this.pkg);
        Mockito.when((Object)this.pkg.getPackageName()).thenReturn((Object)"mypackage");
        Mockito.when((Object)this.pkg.getPackageMainResourcesPath()).thenReturn((Object)PathFactory.newPath((String)"mypackage", (String)"default://project/src/main/resources"));
        Mockito.when((Object)this.fileSystem.provider()).thenReturn((Object)this.fileSystemProvider);
        Mockito.when((Object)this.fileSystemProvider.readAttributes((Path)Mockito.any(Path.class), (Class)Mockito.any(Class.class), new LinkOption[0])).thenReturn((Object)this.basicFileAttributes);
        Mockito.when((Object)this.basicFileAttributes.isRegularFile()).thenReturn((Object)true);
    }

    @Test
    public void checkCreate() {
        org.uberfire.backend.vfs.Path context = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String fileName = "filename." + this.dtType.getSuffix();
        GuidedDecisionTable52 content = new GuidedDecisionTable52();
        String comment = "comment";
        Mockito.when((Object)context.toURI()).thenReturn((Object)"default://project/src/main/resources/mypackage");
        org.uberfire.backend.vfs.Path p = this.service.create(context, fileName, content, "comment");
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.any(Path.class), (String)Mockito.any(String.class), new OpenOption[]{(OpenOption)Mockito.any(CommentedOption.class)});
        Assert.assertTrue((boolean)p.toURI().contains("src/main/resources/mypackage/filename." + this.dtType.getSuffix()));
        Assert.assertEquals((Object)"mypackage", (Object)content.getPackageName());
    }

    @Test
    public void checkLoad() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://project/src/main/resources/mypackage/dtable.gdst");
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)"");
        GuidedDecisionTable52 model = this.service.load(path);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).readAllString((Path)Mockito.any(Path.class));
        Assert.assertNotNull((Object)model);
    }

    @Test
    public void checkConstructContent() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        PackageDataModelOracle oracle = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        HashSet workItemDefinitions = new HashSet();
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://project/src/main/resources/mypackage/dtable.gdst");
        Mockito.when((Object)this.dataModelService.getDataModel((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path))).thenReturn((Object)oracle);
        Mockito.when((Object)this.workItemsService.loadWorkItemDefinitions((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path))).thenReturn(workItemDefinitions);
        GuidedDecisionTableEditorContent content = this.service.constructContent(path, overview);
        ((Event)Mockito.verify(this.resourceOpenedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(ResourceOpenedEvent.class));
        Assert.assertNotNull((Object)content.getModel());
        Assert.assertNotNull((Object)content.getDataModel());
        Assert.assertNotNull((Object)content.getWorkItemDefinitions());
        Assert.assertEquals((Object)overview, (Object)content.getOverview());
    }

    @Test
    public void checkSave() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        String comment = "comment";
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://project/src/main/resources/mypackage/dtable.gdst");
        this.service.save(path, model, metadata, "comment");
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.any(Path.class), (String)Mockito.any(String.class), (Map)Mockito.any(Map.class), new OpenOption[]{(OpenOption)Mockito.any(CommentedOption.class)});
        Assert.assertEquals((Object)"mypackage", (Object)model.getPackageName());
    }

    @Test
    public void checkSaveAndUpdateGraphEntries() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        String comment = "comment";
        String headPathUri = "default://project/src/main/resources/mypackage/dtable.gdst";
        String versionPathUri = "default://0123456789@project/src/main/resources/mypackage/dtable.gdst";
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://project/src/main/resources/mypackage/dtable.gdst");
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"dtable.gdst");
        ArrayList<PortableVersionRecord> versions = new ArrayList<PortableVersionRecord>();
        versions.add(new PortableVersionRecord("0123456789", "manstis", "manstis@email.com", "comment", Calendar.getInstance().getTime(), "default://0123456789@project/src/main/resources/mypackage/dtable.gdst"));
        Mockito.when((Object)this.versionRecordService.load((Path)Mockito.any(Path.class))).thenReturn(versions);
        URI dtGraphPathUri = URI.create("default://project/src/main/resources/mypackage/graph1.gdst-set");
        Path dtGraphPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)dtGraphPath.toUri()).thenReturn((Object)dtGraphPathUri);
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)dtGraphPath);
        Mockito.when((Object)dtGraphPath.getFileSystem()).thenReturn((Object)this.fileSystem);
        ArrayList<Path> dtGraphPaths = new ArrayList<Path>();
        dtGraphPaths.add(dtGraphPath);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(Path.class), (DirectoryStream.Filter)Mockito.any(FileExtensionFilter.class))).thenReturn((Object)new MockDirectoryStream(dtGraphPaths));
        GuidedDecisionTableEditorGraphModel dtGraphModel = new GuidedDecisionTableEditorGraphModel();
        dtGraphModel.getEntries().add(new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry(path, path));
        Mockito.when((Object)this.dtableGraphService.load((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)dtGraphModel);
        this.service.saveAndUpdateGraphEntries(path, model, metadata, "comment");
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).startBatch((FileSystem)Mockito.any(FileSystem.class));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.any(Path.class), (String)Mockito.any(String.class), (Map)Mockito.any(Map.class), new OpenOption[]{(OpenOption)Mockito.any(CommentedOption.class)});
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).endBatch();
        Assert.assertEquals((Object)"mypackage", (Object)model.getPackageName());
        Assert.assertEquals((long)1L, (long)dtGraphModel.getEntries().size());
        Assert.assertEquals((Object)((VersionRecord)versions.get(0)).uri(), (Object)((GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry)dtGraphModel.getEntries().iterator().next()).getPathVersion().toURI());
    }

    @Test
    public void checkDelete() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String comment = "comment";
        this.service.delete(path, "comment");
        ((DeleteService)Mockito.verify((Object)this.deleteService, (VerificationMode)Mockito.times((int)1))).delete((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Mockito.eq((Object)"comment"));
    }

    @Test
    public void checkRename() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String newFileName = "newFileName";
        String comment = "comment";
        this.service.rename(path, "newFileName", "comment");
        ((RenameService)Mockito.verify((Object)this.renameService, (VerificationMode)Mockito.times((int)1))).rename((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Mockito.eq((Object)"newFileName"), (String)Mockito.eq((Object)"comment"));
    }

    @Test
    public void checkCopy() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String newFileName = "newFileName";
        String comment = "comment";
        this.service.copy(path, "newFileName", "comment");
        ((CopyService)Mockito.verify((Object)this.copyService, (VerificationMode)Mockito.times((int)1))).copy((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Mockito.eq((Object)"newFileName"), (String)Mockito.eq((Object)"comment"));
    }

    @Test
    public void copyCopyToPackage() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String newFileName = "newFileName";
        org.uberfire.backend.vfs.Path newPackagePath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String comment = "comment";
        this.service.copy(path, "newFileName", newPackagePath, "comment");
        ((CopyService)Mockito.verify((Object)this.copyService, (VerificationMode)Mockito.times((int)1))).copy((org.uberfire.backend.vfs.Path)Mockito.eq((Object)path), (String)Mockito.eq((Object)"newFileName"), (org.uberfire.backend.vfs.Path)Mockito.eq((Object)newPackagePath), (String)Mockito.eq((Object)"comment"));
    }

    @Test
    public void checkToSource() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        SourceService mockSourceService = (SourceService)Mockito.mock(SourceService.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://project/src/main/resources/mypackage");
        Mockito.when((Object)this.mockSourceServices.getServiceFor((Path)Mockito.any(Path.class))).thenReturn((Object)mockSourceService);
        this.service.toSource(path, model);
        ((SourceServices)Mockito.verify((Object)this.mockSourceServices, (VerificationMode)Mockito.times((int)1))).getServiceFor((Path)Mockito.any(Path.class));
        ((SourceService)Mockito.verify((Object)mockSourceService, (VerificationMode)Mockito.times((int)1))).getSource((Path)Mockito.any(Path.class), Mockito.eq((Object)model));
    }

    @Test
    public void checkValidate() {
    }
}

