/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDecisionTableSourceService;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.guvnor.common.services.project.model.Package;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedDecisionTableSourceServiceTest {
    @Mock
    Path path;
    @Mock
    Package packageMock;
    @Mock
    FileSystem fileSystem;
    @Mock
    KieProjectService projectService;
    @Mock
    FileDiscoveryService discoveryService;
    @Mock
    GuidedDTableResourceTypeDefinition resourceTypeDefinition;
    @Mock
    GuidedDecisionTableEditorService guidedDecisionTableEditorService;
    @Mock
    IOService ioService;
    @Mock
    FileDiscoveryService fileDiscoveryService;
    GuidedDecisionTable52 model;
    GuidedDecisionTableSourceService service;
    Pattern52 pattern;
    ConditionCol52 condition;
    List<List<DTCellValue52>> data;

    @Before
    public void setUp() throws Exception {
        this.service = new GuidedDecisionTableSourceService(this.resourceTypeDefinition, this.guidedDecisionTableEditorService, this.ioService, this.fileDiscoveryService, this.projectService);
        Mockito.when((Object)this.projectService.resolvePackage((org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)this.packageMock);
        Mockito.when((Object)this.discoveryService.discoverFiles((Path)Matchers.any(), (DirectoryStream.Filter)Matchers.any())).thenReturn(new ArrayList());
        Mockito.when((Object)this.fileSystem.supportedFileAttributeViews()).thenReturn(new HashSet());
        Mockito.when((Object)this.path.getFileSystem()).thenReturn((Object)this.fileSystem);
        Mockito.when((Object)this.path.toString()).thenReturn((Object)"/");
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)this.path);
        Mockito.when((Object)this.path.toUri()).thenReturn((Object)new URI("/"));
        this.model = new GuidedDecisionTable52();
        this.model.setPackageName("som.sample");
        this.model.setImports(new Imports(Arrays.asList(new Import("com.sample.Person"))));
        this.model.setRowNumberCol(new RowNumberCol52());
        this.model.setDescriptionCol(new DescriptionCol52());
        this.pattern = new Pattern52();
        this.pattern.setBoundName("$p");
        this.pattern.setFactType("Person");
        this.condition = new ConditionCol52();
        this.condition.setConstraintValueType(1);
        this.condition.setHeader("name equals to");
        this.condition.setFactField("name");
        this.condition.setOperator("==");
        this.pattern.setChildColumns(Arrays.asList(this.condition));
        this.model.setConditionPatterns(Arrays.asList(this.pattern));
        this.data = new ArrayList<List<DTCellValue52>>();
    }

    @Test
    public void testOtherwise() throws Exception {
        this.addRow(1, "John", false);
        this.addRow(2, "Peter", false);
        this.addRow(3, null, true);
        this.model.setData(this.data);
        String source = this.service.getSource(this.path, this.model);
        Assert.assertTrue((String)"Expected: name == \"John\"", (boolean)source.contains("$p : Person( name == \"John\" )"));
        Assert.assertTrue((String)"Expected: name == \"Peter\"", (boolean)source.contains("$p : Person( name == \"Peter\" )"));
        Assert.assertTrue((String)"Expected: name not in ( \"John\", \"Peter\" )", (boolean)source.contains("$p : Person( name not in ( \"John\", \"Peter\" )"));
    }

    @Test
    public void testOtherwiseTwoSameValues() throws Exception {
        this.addRow(1, "John", false);
        this.addRow(2, "John", false);
        this.addRow(3, null, true);
        this.model.setData(this.data);
        String source = this.service.getSource(this.path, this.model);
        Assert.assertTrue((String)"Expected: name not in ( \"John\" )", (boolean)source.contains("$p : Person( name not in ( \"John\" )"));
    }

    @Test
    public void testOtherwiseEmptyValue() throws Exception {
        this.addRow(1, "John", false);
        this.addRow(2, "", false);
        this.addRow(3, null, true);
        this.model.setData(this.data);
        String source = this.service.getSource(this.path, this.model);
        Assert.assertTrue((String)"Expected: name not in ( \"John\", \"\" )", (boolean)source.contains("$p : Person( name not in ( \"John\", \"\" )"));
    }

    @Test
    public void testOtherwiseEmptyAndNullValue() throws Exception {
        this.addRow(1, "", false);
        this.addRow(2, null, false);
        this.addRow(3, null, true);
        this.model.setData(this.data);
        String source = this.service.getSource(this.path, this.model);
        Assert.assertTrue((String)"Expected: name not in ( \"\" )", (boolean)source.contains("$p : Person( name not in ( \"\" )"));
    }

    @Test
    public void testOtherwiseTwoTimes() throws Exception {
        this.addRow(1, "John", false);
        this.addRow(2, null, true);
        this.addRow(3, "Peter", false);
        this.addRow(4, null, true);
        this.model.setData(this.data);
        String source = this.service.getSource(this.path, this.model);
        Assert.assertTrue((String)"Expected: name not in ( \"John\", \"Peter\" )", (boolean)source.contains("$p : Person( name not in ( \"John\", \"Peter\" )"));
        source.replaceFirst("John", "");
        Assert.assertTrue((String)"Expected: name not in ( \"John\", \"Peter\" )", (boolean)source.contains("$p : Person( name not in ( \"John\", \"Peter\" )"));
    }

    private void addRow(final int rowNumber, final String conditionValue, final boolean isOtherwise) {
        this.data.add((List<DTCellValue52>)new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(rowNumber)));
                this.add(new DTCellValue52("row " + rowNumber));
                if (!isOtherwise) {
                    this.add(new DTCellValue52(conditionValue));
                } else {
                    DTCellValue52 otherwise = new DTCellValue52();
                    otherwise.setOtherwise(true);
                    this.add(otherwise);
                }
            }
        });
    }
}

