/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.drools.core.util.DateUtils;
import org.drools.core.util.StringUtils;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.util.ColumnUtilitiesBase;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.BRLColumnDataBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.XLSColumnUtilities;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.ColumnContext;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;

public class DataBuilder {
    private static final int FIRST_DATA_ROW = 9;
    private final Sheet sheet;
    private final GuidedDecisionTable52 dtable;
    private final ColumnContext columnContext;
    private final ColumnUtilitiesBase utilsWithRespectForLists;
    private final ColumnUtilitiesBase utilsWithNoRespectForLists;
    private int rowCount = 9;

    public DataBuilder(Sheet sheet, GuidedDecisionTable52 dtable, PackageDataModelOracle dmo, ColumnContext columnContext) {
        this.sheet = (Sheet)PortablePreconditions.checkNotNull((String)"sheet", (Object)sheet);
        this.dtable = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"dtable", (Object)dtable);
        this.columnContext = (ColumnContext)PortablePreconditions.checkNotNull((String)"columnContext", (Object)columnContext);
        PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.utilsWithRespectForLists = new XLSColumnUtilities(dtable, dmo, true);
        this.utilsWithNoRespectForLists = new XLSColumnUtilities(dtable, dmo, false);
    }

    public void build() {
        for (List row : this.dtable.getData()) {
            new DataRowBuilder(row).build();
        }
    }

    public class DataRowBuilder {
        private final Row xlsRow;
        private final Set<String> addedInserts;
        private final List<DTCellValue52> row;
        private int sourceColumnIndex;
        private int targetColumnIndex;

        public GuidedDecisionTable52 getDtable() {
            return DataBuilder.this.dtable;
        }

        public int getTargetColumnIndex() {
            return this.targetColumnIndex;
        }

        public void moveToNextTargetColumnIndex() {
            ++this.targetColumnIndex;
        }

        public int getSourceColumnIndex() {
            return this.sourceColumnIndex;
        }

        public void moveSourceColumnIndexForward() {
            ++this.sourceColumnIndex;
        }

        public DataRowBuilder(List<DTCellValue52> row) {
            this.xlsRow = DataBuilder.this.sheet.createRow(DataBuilder.this.rowCount);
            this.addedInserts = new HashSet<String>();
            this.sourceColumnIndex = 0;
            this.targetColumnIndex = -2;
            this.row = row;
        }

        public void build() {
            while (this.sourceColumnIndex < this.row.size()) {
                DTCellValue52 cell = this.row.get(this.sourceColumnIndex);
                if (this.sourceColumnIndex == 2) {
                    this.xlsRow.createCell(this.targetColumnIndex).setCellValue(cell.getStringValue());
                } else if (this.sourceColumnIndex > 2) {
                    BaseColumn baseColumn = (BaseColumn)DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex);
                    if (baseColumn instanceof BRLActionVariableColumn) {
                        this.addBRLActionVariableColumn((BRLActionVariableColumn)baseColumn);
                    } else if (baseColumn instanceof BRLConditionVariableColumn) {
                        this.addBRLConditionVariableColumn((BRLConditionVariableColumn)baseColumn);
                    } else {
                        if (baseColumn instanceof ActionInsertFactCol52) {
                            this.addActionInsertFirstColumn();
                        }
                        if (this.isOperator("== null") || this.isOperator("!= null")) {
                            this.addNullColumn();
                        } else if (this.isWorkItemColumn()) {
                            this.addWorkItemColumn(cell);
                        } else if (DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex) instanceof ActionRetractFactCol52) {
                            this.addRetractColumn(cell);
                        } else {
                            String value = this.getValue(cell, this.getColumnDataType(this.sourceColumnIndex), true);
                            if (value != null) {
                                this.xlsRow.createCell(this.targetColumnIndex).setCellValue(value);
                            }
                        }
                    }
                }
                ++this.targetColumnIndex;
                ++this.sourceColumnIndex;
            }
            DataBuilder.this.rowCount++;
        }

        public void addRetractColumn(DTCellValue52 cell) {
            if (!StringUtils.isEmpty((CharSequence)cell.getStringValue())) {
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue(cell.getStringValue());
            }
        }

        public void addNullColumn() {
            this.xlsRow.createCell(this.targetColumnIndex).setCellValue("null");
        }

        public void addWorkItemColumn(DTCellValue52 cell) {
            if (cell.getBooleanValue() != null && cell.getBooleanValue().booleanValue()) {
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue("X");
            }
        }

        public void addBRLConditionVariableColumn(BRLConditionVariableColumn baseColumn) {
            BRLConditionColumn brlColumn = DataBuilder.this.dtable.getBRLColumn(baseColumn);
            BRLColumnDataBuilder.make(this, (BRLColumn)brlColumn, DataBuilder.this.columnContext).build(brlColumn, this.row, this.xlsRow);
        }

        public void addBRLActionVariableColumn(BRLActionVariableColumn baseColumn) {
            BRLActionColumn brlColumn = DataBuilder.this.dtable.getBRLColumn(baseColumn);
            BRLColumnDataBuilder.make(this, (BRLColumn)brlColumn, DataBuilder.this.columnContext).build(brlColumn, this.row, this.xlsRow);
        }

        private boolean isWorkItemColumn() {
            BaseColumn column = (BaseColumn)DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex);
            return column instanceof ActionWorkItemCol52 || column instanceof ActionWorkItemSetFieldCol52;
        }

        private void addActionInsertFirstColumn() {
            ActionInsertFactCol52 column = (ActionInsertFactCol52)DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex);
            if (!this.addedInserts.contains(column.getBoundName())) {
                this.addedInserts.add(column.getBoundName());
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue("X");
                ++this.targetColumnIndex;
            }
        }

        public String getValue(List<DTCellValue52> row, int sourceColumnIndex, boolean addQuotes) {
            DTCellValue52 newCell = row.get(sourceColumnIndex);
            return this.getValue(newCell, this.getColumnDataType(sourceColumnIndex), addQuotes);
        }

        public String getValue(List<DTCellValue52> row, int sourceColumnIndex) {
            DTCellValue52 newCell = row.get(sourceColumnIndex);
            return this.getValue(newCell, this.getColumnDataType(sourceColumnIndex), false);
        }

        public String getValue(DTCellValue52 cell, DataType.DataTypes dataType, boolean addQuotes) {
            switch (dataType) {
                case STRING: {
                    return this.getStringValue(cell, addQuotes);
                }
                case NUMERIC: 
                case NUMERIC_BIGDECIMAL: 
                case NUMERIC_BIGINTEGER: 
                case NUMERIC_BYTE: 
                case NUMERIC_DOUBLE: 
                case NUMERIC_FLOAT: 
                case NUMERIC_INTEGER: 
                case NUMERIC_LONG: 
                case NUMERIC_SHORT: {
                    return this.getNumericValue(cell);
                }
                case DATE: {
                    return this.getDateValue(cell, addQuotes);
                }
                case BOOLEAN: {
                    return this.getBooleanValue(cell);
                }
            }
            return null;
        }

        private String getNumericValue(DTCellValue52 cell) {
            Number numericValue = cell.getNumericValue();
            if (numericValue != null) {
                return numericValue.toString();
            }
            return null;
        }

        private String getBooleanValue(DTCellValue52 cell) {
            Boolean booleanValue = cell.getBooleanValue();
            if (booleanValue != null) {
                return booleanValue.toString();
            }
            return null;
        }

        private String getDateValue(DTCellValue52 cell, boolean addQuotes) {
            Date dateValue = cell.getDateValue();
            if (dateValue != null) {
                if (addQuotes) {
                    return String.format("\"%s\"", DateUtils.format((Date)dateValue));
                }
                return DateUtils.format((Date)dateValue);
            }
            return null;
        }

        private String getStringValue(DTCellValue52 cell, boolean addQuotes) {
            if (this.isTheRealCellValueString(this.sourceColumnIndex) && cell.getStringValue() != null) {
                if (cell.getStringValue() != null && !cell.getStringValue().isEmpty()) {
                    if (this.isOperator("in")) {
                        return String.format("(%s)", this.fixStringValue(cell));
                    }
                    if (addQuotes) {
                        return String.format("\"%s\"", this.fixStringValue(cell));
                    }
                    return cell.getStringValue();
                }
            } else if (Objects.equals(DataType.DataTypes.STRING, cell.getDataType())) {
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue(cell.getStringValue());
            } else {
                return this.getValue(cell, cell.getDataType(), addQuotes);
            }
            return null;
        }

        private boolean isOperator(String operator) {
            if (DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex) instanceof ConditionCol52) {
                ConditionCol52 column = (ConditionCol52)DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex);
                return Objects.equals(column.getOperator(), operator);
            }
            return false;
        }

        private String fixStringValue(DTCellValue52 cell) {
            if (cell.getStringValue().length() > 2 && cell.getStringValue().startsWith("\"") && cell.getStringValue().endsWith("\"")) {
                return cell.getStringValue().substring(1, cell.getStringValue().length() - 1);
            }
            return cell.getStringValue();
        }

        private boolean isTheRealCellValueString(int sourceColumnIndex) {
            return !(DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex) instanceof AttributeCol52) && !(DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex) instanceof MetadataCol52) && !this.isFormula(sourceColumnIndex) && Objects.equals(DataType.DataTypes.STRING, DataBuilder.this.utilsWithNoRespectForLists.getTypeSafeType((BaseColumn)DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex)));
        }

        private boolean isFormula(int sourceColumnIndex) {
            int constraintValueType;
            return DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex) instanceof ConditionCol52 && ((constraintValueType = ((ConditionCol52)DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex)).getConstraintValueType()) == 3 || constraintValueType == 5);
        }

        public DataType.DataTypes getColumnDataType(int columnIndex) {
            return DataBuilder.this.utilsWithRespectForLists.getTypeSafeType((BaseColumn)DataBuilder.this.dtable.getExpandedColumns().get(columnIndex));
        }
    }
}

