/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.poi.ss.usermodel.Workbook;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSService;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.XLSBuilder;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.shared.XLSConversionResult;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

public class DecisionTableGuidedToDecisionTableXLSConverter {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private GuidedDecisionTableEditorService guidedDecisionTableEditorService;
    @Inject
    private DecisionTableXLSService decisionTableXLSService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private SessionInfo sessionInfo;

    public XLSConversionResult convert(org.uberfire.backend.vfs.Path originPath) throws IOException {
        PackageDataModelOracle dmo = this.dataModelService.getDataModel(originPath);
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)this.guidedDecisionTableEditorService.load(originPath);
        XLSBuilder.BuildResult buildResult = new XLSBuilder(dtable, dmo).build();
        if (buildResult.getConversionResult().isConverted()) {
            Workbook workbook = buildResult.getWorkbook();
            ByteArrayOutputStream fileOut = new ByteArrayOutputStream();
            workbook.write((OutputStream)fileOut);
            ByteArrayInputStream inStream = new ByteArrayInputStream(fileOut.toByteArray());
            this.decisionTableXLSService.create(this.getDestinationFilePath(originPath), (InputStream)inStream, this.sessionInfo.getId(), "Converted from " + originPath.getFileName());
            fileOut.close();
            workbook.close();
            inStream.close();
        }
        return buildResult.getConversionResult();
    }

    private org.uberfire.backend.vfs.Path getDestinationFilePath(org.uberfire.backend.vfs.Path originPath) {
        org.uberfire.backend.vfs.Path result = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)originPath).getParent().resolve(originPath.getFileName() + " export.xls"));
        int index = 1;
        while (this.ioService.exists(Paths.convert((org.uberfire.backend.vfs.Path)result))) {
            result = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)originPath).getParent().resolve(String.format("%s export (%d).xls", originPath.getFileName(), index)));
            ++index;
        }
        return result;
    }
}

