/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.BRLColumnDataBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.DataBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.ColumnContext;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.FromTo;

public class BRLColumnDataBuilderByPatterns
implements BRLColumnDataBuilder {
    private DataBuilder.DataRowBuilder dataRowBuilder;
    private ColumnContext columnContext;

    public BRLColumnDataBuilderByPatterns(DataBuilder.DataRowBuilder dataRowBuilder, ColumnContext columnContext) {
        this.dataRowBuilder = dataRowBuilder;
        this.columnContext = columnContext;
    }

    @Override
    public void build(BRLConditionColumn baseColumn, List<DTCellValue52> row, Row xlsRow) {
        this.addColumnValuesToRow(row, xlsRow, this.columnContext.getCols((BRLColumn)baseColumn));
        this.advanceSourceColumnIndex((CompositeColumn)baseColumn);
    }

    @Override
    public void build(BRLActionColumn baseColumn, List<DTCellValue52> row, Row xlsRow) {
        this.addColumnValuesToRow(row, xlsRow, this.columnContext.getCols((BRLColumn)baseColumn));
        this.advanceSourceColumnIndex((CompositeColumn)baseColumn);
    }

    private void addColumnValuesToRow(List<DTCellValue52> row, Row xlsRow, List<FromTo> columns) {
        Iterator<FromTo> iterator = columns.iterator();
        while (iterator.hasNext()) {
            FromTo fromTo = iterator.next();
            if (fromTo.shouldUseATickAsValue() && this.containsValues(columns, row)) {
                xlsRow.createCell(fromTo.getToColumnIndex()).setCellValue("X");
            } else {
                String value = this.dataRowBuilder.getValue(row, fromTo.getFromColumnIndex(), true);
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    xlsRow.createCell(this.dataRowBuilder.getTargetColumnIndex()).setCellValue(value);
                }
            }
            if (!iterator.hasNext()) continue;
            this.dataRowBuilder.moveToNextTargetColumnIndex();
        }
    }

    private boolean containsValues(List<FromTo> cols, List<DTCellValue52> row) {
        for (FromTo fromTo : cols) {
            if (fromTo.shouldUseATickAsValue() || !StringUtils.isNotEmpty((CharSequence)this.dataRowBuilder.getValue(row, fromTo.getToColumnIndex()))) continue;
            return true;
        }
        return false;
    }

    private void advanceSourceColumnIndex(CompositeColumn baseColumn) {
        Iterator iterator = baseColumn.getChildColumns().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            if (!iterator.hasNext()) continue;
            this.dataRowBuilder.moveSourceColumnIndexForward();
        }
    }
}

