/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.BRLColumnSubHeaderBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.SubHeaderBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.ColumnContext;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.FromTo;

public class BRLColumnSubHeaderBuilderByPatterns
implements BRLColumnSubHeaderBuilder {
    private SubHeaderBuilder subHeaderBuilder;
    private ColumnContext columnContext;
    private GuidedDecisionTable52 dtable;

    public BRLColumnSubHeaderBuilderByPatterns(SubHeaderBuilder subHeaderBuilder, ColumnContext columnContext, GuidedDecisionTable52 dtable) {
        this.subHeaderBuilder = subHeaderBuilder;
        this.columnContext = columnContext;
        this.dtable = dtable;
    }

    @Override
    public void buildBrlActions(BRLActionColumn brlColumn) {
        for (IAction iAction : brlColumn.getDefinition()) {
            Iterator<String> variablesIterator = this.columnContext.getVariablesInOrderOfUse(iAction).iterator();
            String boundName = this.getBoundName(iAction);
            while (variablesIterator.hasNext()) {
                ActionCol52 childColumn = this.getChildActionColumn(variablesIterator.next(), brlColumn.getChildColumns());
                if (childColumn instanceof BRLActionVariableColumn) {
                    this.addBRLActionVariableColumn(brlColumn, boundName, (BRLActionVariableColumn)childColumn);
                }
                this.updateColumnContext(brlColumn, childColumn);
                if (!variablesIterator.hasNext()) continue;
                this.subHeaderBuilder.incrementTargetIndex();
            }
        }
    }

    public void addBRLActionVariableColumn(BRLActionColumn brlColumn, String boundName, BRLActionVariableColumn childColumn) {
        boolean madeInsert = this.subHeaderBuilder.addInsert(brlColumn.getHeader(), boundName, childColumn.getFactType(), childColumn.getFactField(), "");
        if (madeInsert) {
            this.addInsertColumn(brlColumn, childColumn);
        }
    }

    public void addInsertColumn(BRLActionColumn brlColumn, BRLActionVariableColumn childColumn) {
        this.subHeaderBuilder.getColumnContext().put((BRLColumn)brlColumn, FromTo.makePlaceHolder(this.dtable.getExpandedColumns().indexOf(childColumn), this.subHeaderBuilder.getTargetColumnIndex() - 1));
    }

    private String getBoundName(IAction iAction) {
        if (iAction instanceof ActionSetField && StringUtils.isNotEmpty((CharSequence)((ActionSetField)iAction).getVariable())) {
            return ((ActionSetField)iAction).getVariable();
        }
        return this.columnContext.getNextFreeColumnFactName();
    }

    @Override
    public void buildBrlConditions(BRLConditionColumn brlColumn) {
        Iterator<String> variablesIterator = this.columnContext.getVariablesInOrderOfUse(brlColumn).iterator();
        while (variablesIterator.hasNext()) {
            ConditionCol52 childColumn = this.getChildConditionColumn(variablesIterator.next(), brlColumn.getChildColumns());
            this.subHeaderBuilder.addCondition(childColumn);
            this.updateColumnContext(brlColumn, childColumn);
            if (!variablesIterator.hasNext()) continue;
            this.subHeaderBuilder.incrementTargetIndex();
        }
    }

    private ActionCol52 getChildActionColumn(String varName, List<BRLActionVariableColumn> childColumns) {
        for (BRLActionVariableColumn childColumn : childColumns) {
            if (!Objects.equals(childColumn.getVarName(), varName)) continue;
            return childColumn;
        }
        throw new IllegalArgumentException("Found a variable for a column that does not exist");
    }

    private ConditionCol52 getChildConditionColumn(String varName, List<BRLConditionVariableColumn> childColumns) {
        for (BRLConditionVariableColumn childColumn : childColumns) {
            if (!Objects.equals(childColumn.getVarName(), varName)) continue;
            return childColumn;
        }
        throw new IllegalArgumentException("Found a variable for a column that does not exist");
    }

    public void updateColumnContext(BRLConditionColumn brlColumn, ConditionCol52 childColumn) {
        this.subHeaderBuilder.getColumnContext().put((BRLColumn)brlColumn, FromTo.makeFromTo(this.dtable.getExpandedColumns().indexOf(childColumn), this.dtable.getExpandedColumns().indexOf(childColumn)));
    }

    public void updateColumnContext(BRLActionColumn brlColumn, ActionCol52 childColumn) {
        this.subHeaderBuilder.getColumnContext().put((BRLColumn)brlColumn, FromTo.makeFromTo(this.dtable.getExpandedColumns().indexOf(childColumn), this.subHeaderBuilder.getTargetColumnIndex()));
    }
}

