/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTDRLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.BRLColumnSubHeaderBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.SubHeaderBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.ColumnContext;

public class BRLColumnSubHeaderBuilderDefault
implements BRLColumnSubHeaderBuilder {
    private SubHeaderBuilder subHeaderBuilder;
    private ColumnContext columnContext;
    private final GuidedDecisionTable52 dtable;
    private final Map<String, String> varListInOrder = new HashMap<String, String>();

    public BRLColumnSubHeaderBuilderDefault(SubHeaderBuilder subHeaderBuilder, ColumnContext columnContext, GuidedDecisionTable52 dtable) {
        this.subHeaderBuilder = subHeaderBuilder;
        this.columnContext = columnContext;
        this.dtable = dtable;
    }

    @Override
    public void buildBrlActions(BRLActionColumn brlColumn) {
        this.subHeaderBuilder.addHeaderAndTitle("ACTION", brlColumn.getHeader());
        this.subHeaderBuilder.getFieldRow().createCell(this.subHeaderBuilder.getTargetColumnIndex()).setCellValue(this.replaceTempVars(brlColumn.getChildColumns(), this.makeRHSDrl(brlColumn)));
    }

    @Override
    public void buildBrlConditions(BRLConditionColumn brlColumn) {
        for (IPattern iPattern : brlColumn.getDefinition()) {
            if (!(iPattern instanceof FactPattern)) continue;
            this.columnContext.addBoundName(((FactPattern)iPattern).getBoundName());
        }
        this.subHeaderBuilder.addHeaderAndTitle("CONDITION", brlColumn.getHeader());
        this.subHeaderBuilder.getFieldRow().createCell(this.subHeaderBuilder.getTargetColumnIndex()).setCellValue(this.replaceTempVars(brlColumn.getChildColumns(), this.makeLHSDrl(brlColumn)));
    }

    private String makeRHSDrl(BRLActionColumn brlColumn) {
        return this.subString(GuidedDTDRLPersistence.getInstance().marshal(this.makeTempFullGuidedDecisionTable(brlColumn)), "then", "end");
    }

    private void updateBoundNames(BRLActionColumn brlColumn) {
        for (IAction iAction : brlColumn.getDefinition()) {
            ActionInsertFact insertFact;
            if (!(iAction instanceof ActionInsertFact) || (insertFact = (ActionInsertFact)iAction).getBoundName() != null) continue;
            insertFact.setBoundName(this.getBoundName(insertFact));
        }
    }

    private String getBoundName(ActionInsertFact insertFact) {
        if (StringUtils.isNotEmpty((CharSequence)insertFact.getBoundName())) {
            return insertFact.getBoundName();
        }
        return this.columnContext.getNextFreeColumnFactName();
    }

    private String makeLHSDrl(BRLConditionColumn brlColumn) {
        return this.subString(GuidedDTDRLPersistence.getInstance().marshal(this.makeTempLHSGuidedDecisionTable(brlColumn)), "when", "then");
    }

    private GuidedDecisionTable52 makeTempFullGuidedDecisionTable(BRLActionColumn brlColumn) {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.getAttributeCols().addAll(this.dtable.getAttributeCols());
        dt.getMetadataCols().addAll(this.dtable.getMetadataCols());
        dt.getConditions().addAll(this.dtable.getConditions());
        ArrayList<DTCellValue52> list = new ArrayList<DTCellValue52>();
        this.updateBoundNames(brlColumn);
        for (int i = 0; i < dt.getExpandedColumns().size(); ++i) {
            list.add((DTCellValue52)((List)this.dtable.getData().get(0)).get(i));
        }
        list.addAll(this.setUpVarNamesWithTemps(brlColumn.getChildColumns()));
        dt.getData().add(list);
        dt.getActionCols().add(brlColumn);
        return dt;
    }

    private GuidedDecisionTable52 makeTempLHSGuidedDecisionTable(BRLConditionColumn brlColumn) {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.getConditions().add(brlColumn);
        ArrayList<DTCellValue52> list = new ArrayList<DTCellValue52>();
        list.add(new DTCellValue52(Integer.valueOf(1)));
        list.add(new DTCellValue52(""));
        list.add(new DTCellValue52(""));
        list.addAll(this.setUpVarNamesWithTemps(brlColumn.getChildColumns()));
        dt.getData().add(list);
        return dt;
    }

    private List<DTCellValue52> setUpVarNamesWithTemps(List<? extends BRLVariableColumn> childColumns) {
        ArrayList<DTCellValue52> result = new ArrayList<DTCellValue52>();
        for (int i = 0; i < childColumns.size(); ++i) {
            BRLVariableColumn brlConditionVariableColumn = childColumns.get(i);
            this.columnContext.addBoundName(brlConditionVariableColumn.getVarName());
            if (StringUtils.isEmpty((CharSequence)brlConditionVariableColumn.getVarName())) {
                result.add(new DTCellValue52(Boolean.valueOf(true)));
                continue;
            }
            String varName = brlConditionVariableColumn.getVarName();
            String key = "";
            if (!varName.startsWith("$")) {
                key = varName;
                varName = "@{" + varName + "}";
            } else {
                key = Integer.toString(i);
                varName = "@{" + i + "}";
            }
            this.varListInOrder.put(brlConditionVariableColumn.getVarName(), key);
            result.add(new DTCellValue52(varName));
        }
        return result;
    }

    private String replaceTempVars(List<? extends BRLVariableColumn> childColumns, String drl) {
        int varIndex = 1;
        String result = drl;
        for (BRLVariableColumn bRLVariableColumn : childColumns) {
            String var = this.varListInOrder.get(bRLVariableColumn.getVarName());
            Pattern pattern = Pattern.compile("@\\{(" + var + ")}");
            Matcher matcher = pattern.matcher(result);
            result = matcher.replaceAll("\\$" + varIndex++);
        }
        return result;
    }

    private String subString(String marshal, String from, String to) {
        Pattern regex = Pattern.compile("\\s*" + from + "\\s*(.*)" + to, 32);
        Matcher regexMatcher = regex.matcher(marshal);
        if (regexMatcher.find()) {
            return regexMatcher.group(1);
        }
        throw new IllegalStateException(String.format("No substring between '%s' and '%s' found", from, to));
    }
}

