/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.utils;

import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.commons.validation.PortablePreconditions;

public class GuidedDecisionTableUtils {
    private final GuidedDecisionTable52 model;
    private final AsyncPackageDataModelOracle oracle;

    public GuidedDecisionTableUtils(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle) {
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.oracle = (AsyncPackageDataModelOracle)PortablePreconditions.checkNotNull((String)"oracle", (Object)oracle);
    }

    public String getType(BaseColumn col) {
        if (col instanceof RowNumberCol52) {
            return this.getType((RowNumberCol52)col);
        }
        if (col instanceof AttributeCol52) {
            return this.getType((AttributeCol52)col);
        }
        if (col instanceof BRLConditionVariableColumn) {
            return this.getType((BRLConditionVariableColumn)col);
        }
        if (col instanceof ConditionCol52) {
            return this.getType((ConditionCol52)col);
        }
        if (col instanceof ActionSetFieldCol52) {
            return this.getType((ActionSetFieldCol52)col);
        }
        if (col instanceof ActionInsertFactCol52) {
            return this.getType((ActionInsertFactCol52)col);
        }
        if (col instanceof BRLActionVariableColumn) {
            return this.getType((BRLActionVariableColumn)col);
        }
        return "String";
    }

    private String getType(RowNumberCol52 col) {
        return "Integer";
    }

    private String getType(AttributeCol52 col) {
        String type = "String";
        String attrName = col.getAttribute();
        if (attrName.equals("salience")) {
            type = "Integer";
        } else if (attrName.equals("enabled")) {
            type = "Boolean";
        } else if (attrName.equals("no-loop")) {
            type = "Boolean";
        } else if (attrName.equals("duration")) {
            type = "Long";
        } else if (attrName.equals("timer")) {
            type = "String";
        } else if (attrName.equals("calendars")) {
            type = "String";
        } else if (attrName.equals("auto-focus")) {
            type = "Boolean";
        } else if (attrName.equals("lock-on-active")) {
            type = "Boolean";
        } else if (attrName.equals("date-effective")) {
            type = "Date";
        } else if (attrName.equals("date-expires")) {
            type = "Date";
        } else if (attrName.equals("dialect")) {
            type = "String";
        } else if (attrName.equals("negate")) {
            type = "Boolean";
        }
        return type;
    }

    private String getType(ConditionCol52 col) {
        Pattern52 pattern = this.model.getPattern(col);
        return this.getType(pattern, col);
    }

    private String getType(Pattern52 pattern, ConditionCol52 col) {
        if (this.hasValueList(col)) {
            return "String";
        }
        if (OperatorsOracle.operatorRequiresList((String)col.getOperator())) {
            return "String";
        }
        if (col.getConstraintValueType() == 1 && (col.getOperator() == null || "".equals(col.getOperator()))) {
            return "String";
        }
        if (col.getConstraintValueType() == 5) {
            return "String";
        }
        if (col.getConstraintValueType() == 3) {
            return "String";
        }
        String factType = pattern.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    private String getType(BRLConditionVariableColumn col) {
        if (col.getFactType() == null && col.getFactField() == null) {
            return col.getFieldType();
        }
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    private String getType(ActionSetFieldCol52 col) {
        if (this.hasValueList(col)) {
            return "String";
        }
        String factType = this.getBoundFactType(col.getBoundName());
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    private String getType(Pattern52 pattern, ActionSetFieldCol52 col) {
        if (this.hasValueList(col)) {
            return "String";
        }
        String factType = pattern.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    private String getType(ActionInsertFactCol52 col) {
        if (this.hasValueList(col)) {
            return "String";
        }
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    private String getType(BRLActionVariableColumn col) {
        if (col.getFactType() == null && col.getFactField() == null) {
            return col.getFieldType();
        }
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    private String getTypeFromDataOracle(String factType, String fieldName) {
        String type = this.oracle.getFieldType(factType, fieldName);
        return type;
    }

    public DataType.DataTypes getTypeSafeType(BaseColumn column) {
        String type = this.getType(column);
        return this.convertToTypeSafeType(type);
    }

    public DataType.DataTypes getTypeSafeType(Pattern52 pattern, ConditionCol52 column) {
        String type = this.getType(pattern, column);
        return this.convertToTypeSafeType(type);
    }

    public DataType.DataTypes getTypeSafeType(Pattern52 pattern, ActionSetFieldCol52 column) {
        String type = this.getType(pattern, column);
        return this.convertToTypeSafeType(type);
    }

    private DataType.DataTypes convertToTypeSafeType(String type) {
        if (type.equals("Numeric")) {
            return DataType.DataTypes.NUMERIC;
        }
        if (type.equals("BigDecimal")) {
            return DataType.DataTypes.NUMERIC_BIGDECIMAL;
        }
        if (type.equals("BigInteger")) {
            return DataType.DataTypes.NUMERIC_BIGINTEGER;
        }
        if (type.equals("Byte")) {
            return DataType.DataTypes.NUMERIC_BYTE;
        }
        if (type.equals("Double")) {
            return DataType.DataTypes.NUMERIC_DOUBLE;
        }
        if (type.equals("Float")) {
            return DataType.DataTypes.NUMERIC_FLOAT;
        }
        if (type.equals("Integer")) {
            return DataType.DataTypes.NUMERIC_INTEGER;
        }
        if (type.equals("Long")) {
            return DataType.DataTypes.NUMERIC_LONG;
        }
        if (type.equals("Short")) {
            return DataType.DataTypes.NUMERIC_SHORT;
        }
        if (type.equals("Boolean")) {
            return DataType.DataTypes.BOOLEAN;
        }
        if (type.equals("Date")) {
            return DataType.DataTypes.DATE;
        }
        return DataType.DataTypes.STRING;
    }

    public String[] getValueList(BaseColumn col) {
        if (col instanceof AttributeCol52) {
            return this.getValueList((AttributeCol52)col);
        }
        if (col instanceof ConditionCol52) {
            return this.getValueList((ConditionCol52)col);
        }
        if (col instanceof ActionSetFieldCol52) {
            return this.getValueList((ActionSetFieldCol52)col);
        }
        if (col instanceof ActionInsertFactCol52) {
            return this.getValueList((ActionInsertFactCol52)col);
        }
        return new String[0];
    }

    private String[] getValueList(AttributeCol52 col) {
        if ("no-loop".equals(col.getAttribute()) || "enabled".equals(col.getAttribute())) {
            return new String[]{"true", "false"};
        }
        return new String[0];
    }

    private String[] getValueList(ConditionCol52 col) {
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return col.getValueList().split(",");
        }
        return new String[0];
    }

    private String[] getValueList(ActionSetFieldCol52 col) {
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return col.getValueList().split(",");
        }
        return new String[0];
    }

    private String[] getValueList(ActionInsertFactCol52 col) {
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return col.getValueList().split(",");
        }
        return new String[0];
    }

    public boolean hasValueList(AttributeCol52 col) {
        return "no-loop".equals(col.getAttribute()) || "enabled".equals(col.getAttribute());
    }

    public boolean hasValueList(ConditionCol52 col) {
        return col.getValueList() != null && !"".equals(col.getValueList());
    }

    public boolean hasValueList(ActionSetFieldCol52 col) {
        return col.getValueList() != null && !"".equals(col.getValueList());
    }

    public boolean hasValueList(ActionInsertFactCol52 col) {
        return col.getValueList() != null && !"".equals(col.getValueList());
    }

    public boolean isConstraintValid(DTColumnConfig52 col) {
        if (col instanceof RowNumberCol52) {
            return true;
        }
        if (col instanceof DescriptionCol52) {
            return true;
        }
        if (col instanceof MetadataCol52) {
            return true;
        }
        if (col instanceof AttributeCol52) {
            return true;
        }
        if (col instanceof ConditionCol52) {
            ConditionCol52 c = (ConditionCol52)col;
            if (c.getConstraintValueType() == 1) {
                if (c.getFactField() == null || c.getFactField().equals("")) {
                    return false;
                }
                return c.getOperator() != null && !c.getOperator().equals("");
            }
            return true;
        }
        return col instanceof ActionCol52;
    }

    public String getBoundFactType(String boundName) {
        for (CompositeColumn cc : this.model.getConditions()) {
            if (cc instanceof Pattern52) {
                Pattern52 p = (Pattern52)cc;
                if (!p.isBound() || !p.getBoundName().equals(boundName)) continue;
                return p.getFactType();
            }
            if (!(cc instanceof BRLConditionColumn)) continue;
            BRLConditionColumn brl = (BRLConditionColumn)cc;
            for (IPattern p : brl.getDefinition()) {
                FactPattern fp;
                if (!(p instanceof FactPattern) || !(fp = (FactPattern)p).isBound() || !fp.getBoundName().equals(boundName)) continue;
                return fp.getFactType();
            }
        }
        return "";
    }

    public boolean hasDSLSentences() {
        BRLConditionColumn brlColumn;
        for (CompositeColumn column : this.model.getConditions()) {
            if (!(column instanceof BRLConditionColumn)) continue;
            brlColumn = (BRLConditionColumn)column;
            for (IPattern pattern : brlColumn.getDefinition()) {
                if (!(pattern instanceof DSLSentence)) continue;
                return true;
            }
        }
        for (CompositeColumn column : this.model.getActionCols()) {
            if (!(column instanceof BRLActionColumn)) continue;
            brlColumn = (BRLActionColumn)column;
            for (IAction action : brlColumn.getDefinition()) {
                if (!(action instanceof DSLSentence)) continue;
                return true;
            }
        }
        return false;
    }
}

