/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.ActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.ActionInspectorKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.action.FactFieldColumnActionInspectorKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.SingleCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class DetectRedundantActionCheck
extends SingleCheck {
    private final List<ActionInspector> inspectorList = new ArrayList<ActionInspector>();
    private ActionInspectorKey key;

    public DetectRedundantActionCheck(RowInspector rowInspector) {
        super(rowInspector);
    }

    @Override
    public void check() {
        for (ActionInspectorKey key : this.rowInspector.getActions().keys()) {
            List actionInspectors = this.rowInspector.getActions().get(key);
            for (int i = 0; i < actionInspectors.size(); ++i) {
                if (actionInspectors.size() <= i - 1) continue;
                for (int j = i + 1; j < actionInspectors.size(); ++j) {
                    if (!((ActionInspector)actionInspectors.get(i)).isRedundant(actionInspectors.get(j))) continue;
                    this.inspectorList.clear();
                    this.inspectorList.add((ActionInspector)actionInspectors.get(i));
                    this.inspectorList.add((ActionInspector)actionInspectors.get(j));
                    this.hasIssues = true;
                    this.key = key;
                    return;
                }
            }
        }
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.WARNING, this.getMessage(), this.rowInspector.getRowIndex() + 1);
        issue.getExplanation().addParagraph(AnalysisConstants.INSTANCE.RedundantActionsP1()).startNote().addParagraph(AnalysisConstants.INSTANCE.RedundantActionsNote1P1(this.inspectorList.get(0).toHumanReadableString(), this.inspectorList.get(1).toHumanReadableString())).end();
        return issue;
    }

    private String getMessage() {
        if (this.key instanceof FactFieldColumnActionInspectorKey) {
            return AnalysisConstants.INSTANCE.ValueForFactFieldIsSetTwice(((FactFieldColumnActionInspectorKey)this.key).getBoundName(), ((FactFieldColumnActionInspectorKey)this.key).getFactField());
        }
        return AnalysisConstants.INSTANCE.ValueForAnActionIsSetTwice();
    }
}

