/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.RowInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.SingleCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspectorKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class DetectRedundantConditionsCheck
extends SingleCheck {
    private final List<ConditionInspector> conditions = new ArrayList<ConditionInspector>();
    private ConditionInspectorKey key;

    public DetectRedundantConditionsCheck(RowInspector rowInspector) {
        super(rowInspector);
    }

    @Override
    public void check() {
        for (ConditionInspectorKey key : this.rowInspector.getConditions().keys()) {
            if (!this.inspect(this.rowInspector.getConditions().get(key))) continue;
            this.key = key;
            this.hasIssues = true;
            return;
        }
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.NOTE, AnalysisConstants.INSTANCE.RedundantConditionsTitle(), this.rowInspector.getRowIndex() + 1);
        issue.getExplanation().startNote().addParagraph(AnalysisConstants.INSTANCE.RedundantConditionsNote1P1(this.key.getPattern().getFactType(), this.key.getFactField())).addParagraph(AnalysisConstants.INSTANCE.RedundantConditionsNote1P2(this.conditions.get(0).toHumanReadableString(), this.conditions.get(1).toHumanReadableString())).end().addParagraph(AnalysisConstants.INSTANCE.RedundantConditionsP1());
        return issue;
    }

    private boolean inspect(Collection<ConditionInspector> conditions) {
        ArrayList<ConditionInspector> conditionInspectors = new ArrayList<ConditionInspector>(conditions);
        for (int i = 0; i < conditionInspectors.size(); ++i) {
            for (int j = i + 1; j < conditionInspectors.size(); ++j) {
                if (!((ConditionInspector)conditionInspectors.get(i)).isRedundant(conditionInspectors.get(j))) continue;
                this.conditions.clear();
                this.conditions.add((ConditionInspector)conditionInspectors.get(i));
                this.conditions.add((ConditionInspector)conditionInspectors.get(j));
                return true;
            }
        }
        return false;
    }
}

