/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition;

import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Operator;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.condition.ConditionInspector;

public class BooleanConditionInspector
extends ConditionInspector {
    private final Operator operator;
    public final Boolean value;

    public BooleanConditionInspector(Pattern52 pattern, String factField, Boolean value, String operator) {
        super(pattern, factField);
        this.operator = Operator.resolve(operator);
        switch (this.operator) {
            case EQUALS: {
                this.value = value;
                break;
            }
            case NOT_EQUALS: {
                this.value = value == false;
                break;
            }
            default: {
                this.value = null;
            }
        }
    }

    @Override
    public boolean isRedundant(Object other) {
        if (this.equals(other)) {
            return true;
        }
        if (other instanceof BooleanConditionInspector) {
            return this.value.compareTo(((BooleanConditionInspector)other).value) == 0;
        }
        return false;
    }

    @Override
    public boolean conflicts(Object other) {
        return !this.isRedundant(other);
    }

    @Override
    public boolean overlaps(Object other) {
        return this.isRedundant(other);
    }

    @Override
    public boolean subsumes(Object other) {
        return this.isRedundant(other);
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public String toHumanReadableString() {
        return this.getFactField() + " " + (Object)((Object)this.operator) + " " + this.value;
    }
}

